package org.jboss.webbeans.integration.ejb;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.resolvers.spi.EjbReference;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolver;
import org.jboss.webbeans.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.webbeans.integration.util.Reflections;

public class JBossBussinessInterfaceDescriptorAdaptor<T> implements BusinessInterfaceDescriptor<T>
{
   private Class<T> type;
   private String jndiName;

   public JBossBussinessInterfaceDescriptorAdaptor(String interfaceName, String ejbName, DeploymentUnit deploymentUnit, EjbReferenceResolver resolver)
   {
      try
      {
         type = (Class<T>) Reflections.classForName(interfaceName, deploymentUnit.getClassLoader());
      }
      catch (ClassCastException e) 
      {
         throw new IllegalStateException("Error loading EJB Session bean interface", e);
      }
      catch (ClassNotFoundException e)
      {
         throw new IllegalStateException("Cannot load EJB Session bean interface", e);
      }
      jndiName = resolver.resolveEjb(deploymentUnit, new EjbReference(ejbName, interfaceName, null));
   }

   public Class<T> getInterface()
   {
      return type;
   }

   public String getJndiName()
   {
      return jndiName;
   }
   
   @Override
   public String toString()
   {
      return getInterface() + " jndi name: " + getJndiName();
   }   
}
