package org.jboss.webbeans.integration.ejb;
import java.util.Iterator;

import javax.naming.Context;
import javax.naming.NamingException;

import org.jboss.webbeans.ejb.api.SessionObjectReference;
import org.jboss.webbeans.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.webbeans.ejb.spi.EjbDescriptor;


public class JBossSessionObjectReference implements SessionObjectReference
{

   private static final long serialVersionUID = 8227728506645839338L;
   
   private final Object reference;
   
   public JBossSessionObjectReference(EjbDescriptor<?> descriptor, Context context) throws NamingException
   {
      Iterator<BusinessInterfaceDescriptor<?>> it = descriptor.getLocalBusinessInterfaces().iterator();
      if (!it.hasNext())
      {
         throw new IllegalStateException("No local interfaces for " + descriptor);
      }
      String fullJndiName = it.next().getJndiName();
      String jndiName = fullJndiName.substring(0, fullJndiName.lastIndexOf("-"));
      reference = context.lookup(jndiName);
   }
   
   public void create()
   {
      if (reference == null)
      {
         
      }
   }
   
   public <S> S getBusinessObject(Class<S> businessInterfaceType)
   {
      return (S) reference;
   }
   
   public void remove()
   {
      // TODO Auto-generated method stub
      
   }
   
}
