package org.jboss.webbeans.integration.messaging;

import javax.inject.ExecutionException;
import javax.jms.Destination;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.jboss.webbeans.messaging.spi.JmsServices;
import org.jboss.webbeans.resources.spi.helpers.AbstractResourceServices;

public class JBossJmsServices extends AbstractResourceServices implements JmsServices
{
   
   private static final String CONNECTION_FACTORY_NAME = "ConnectionFactory";
   
   private final Context context;
   
   public JBossJmsServices() throws NamingException
   {
      this.context = new InitialContext();
   }
   
   @SuppressWarnings("unchecked")
   public <T extends Destination> T resolveDestination(String jndiName, String mappedName)
   {
      return (T) resolveResource(jndiName, mappedName);
   }
   
   public QueueConnectionFactory getQueueConnectionFactory()
   {
      try
      {
         return (QueueConnectionFactory) context.lookup(CONNECTION_FACTORY_NAME);
      }
      catch (NamingException e)
      {
         throw new ExecutionException("Error looking up connection factory in JNDI " + CONNECTION_FACTORY_NAME, e);
      }
   }
   
   public TopicConnectionFactory getTopicConnectionFactory()
   {
      try
      {
         return (TopicConnectionFactory) context.lookup(CONNECTION_FACTORY_NAME);
      }
      catch (NamingException e)
      {
         throw new ExecutionException("Error looking up connection factory in JNDI " + CONNECTION_FACTORY_NAME, e);
      }
   }
   
   @Override
   protected Context getContext()
   {
      return context;
   }
   
}
