package org.jboss.webbeans.integration.jbossas.bootstrap;

import javax.servlet.ServletContext;

import org.jboss.webbeans.bootstrap.spi.EjbDiscovery;
import org.jboss.webbeans.bootstrap.spi.helpers.ForwardingEjbDiscovery;
import org.jboss.webbeans.integration.jbossas.vdf.plugins.JBossEjbDiscoveryVDFConnector;

/**
 * WB 2 EjbDiscovery bridge.
 *
 * @author Pete Muir
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public class ServletJBossEjbDiscovery extends ForwardingEjbDiscovery
{
   private final EjbDiscovery delegate;
   
   public ServletJBossEjbDiscovery(ServletContext servletContext)
   {
      JBossEjbDiscoveryVDFConnector connector = new JBossEjbDiscoveryVDFConnector(servletContext);
      if (connector.isValid() == false)
         throw new IllegalArgumentException("No such bean: " + connector);

      this.delegate = connector.getUtility();
   }
   
   @Override
   public EjbDiscovery delegate()
   {
      return delegate;
   }
}
