package org.jboss.webbeans.integration.jbossas.ejb;


import javax.servlet.ServletContext;

import org.jboss.webbeans.ejb.spi.EjbResolver;
import org.jboss.webbeans.ejb.spi.helpers.ForwardingEjbResolver;
import org.jboss.webbeans.integration.jbossas.vdf.plugins.JBossEjbResolverVDFConnector;

/**
 * An implementation of EjbResolver for JBoss AS
 * 
 * @author Pete Muir
 * @author ales.justin@jboss.org
 */
public class ServletJBossEjbResolver extends ForwardingEjbResolver
{
   private final EjbResolver delegate;
   
   public ServletJBossEjbResolver(ServletContext servletContext)
   {
      JBossEjbResolverVDFConnector connector = new JBossEjbResolverVDFConnector(servletContext);
      if (connector.isValid() == false)
         throw new IllegalArgumentException("No such bean: " + connector);

      delegate = connector.getUtility();
   }
   
   @Override
   public EjbResolver delegate()
   {
      return delegate;
   }
}
