/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.environment.servlet.discovery;

import java.net.URL;
import org.jboss.webbeans.environment.servlet.discovery.Scanner;
import org.jboss.webbeans.environment.servlet.discovery.ServletWebBeanDiscovery;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;

public abstract class AbstractScanner
implements Scanner {
    private static final Log log = Logging.getLog(Scanner.class);
    private final ClassLoader classLoader;
    private final ServletWebBeanDiscovery webBeanDiscovery;

    public AbstractScanner(ClassLoader classLoader, ServletWebBeanDiscovery webBeanDiscovery) {
        this.classLoader = classLoader;
        this.webBeanDiscovery = webBeanDiscovery;
    }

    protected void handle(String name, URL url) {
        if (name.endsWith(".class")) {
            String className = AbstractScanner.filenameToClassname(name);
            try {
                this.webBeanDiscovery.getWbClasses().add(this.getClassLoader().loadClass(className));
            }
            catch (NoClassDefFoundError e) {
                log.error((Object)("Error loading " + name), (Throwable)e, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Error loading " + name), (Throwable)e, new Object[0]);
            }
        } else if (name.endsWith("beans.xml")) {
            this.webBeanDiscovery.getWbUrls().add(url);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }
}

