/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.environment.servlet.discovery;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.jboss.webbeans.bootstrap.spi.WebBeanDiscovery;
import org.jboss.webbeans.environment.servlet.discovery.URLScanner;
import org.jboss.webbeans.environment.servlet.util.Reflections;
import org.jboss.webbeans.environment.servlet.util.Servlets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServletWebBeanDiscovery
implements WebBeanDiscovery {
    private final Set<Class<?>> wbClasses = new HashSet();
    private final Set<URL> wbUrls = new HashSet<URL>();
    private final ServletContext servletContext;

    public ServletWebBeanDiscovery(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.scan();
    }

    public Iterable<Class<?>> discoverWebBeanClasses() {
        return Collections.unmodifiableSet(this.wbClasses);
    }

    public Iterable<URL> discoverWebBeansXml() {
        return Collections.unmodifiableSet(this.wbUrls);
    }

    public Set<Class<?>> getWbClasses() {
        return this.wbClasses;
    }

    public Set<URL> getWbUrls() {
        return this.wbUrls;
    }

    private void scan() {
        URLScanner scanner = new URLScanner(Reflections.getClassLoader(), this);
        scanner.scanResources(new String[]{"beans.xml"});
        try {
            File webInfClasses;
            URL beans = this.servletContext.getResource("/WEB-INF/beans.xml");
            if (beans != null && (webInfClasses = Servlets.getRealFile(this.servletContext, "/WEB-INF/classes")) != null) {
                File[] files = new File[]{webInfClasses};
                scanner.scanDirectories(files);
                this.wbUrls.add(beans);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Error loading resources from servlet context ", e);
        }
    }
}

