package org.jboss.webbeans.tck;

import static org.jboss.webbeans.tck.impl.WebBeansTCKImpl.configuration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import javax.context.CreationalContext;
import javax.inject.Production;
import javax.inject.Standard;
import javax.inject.manager.Bean;
import javax.inject.manager.Manager;

import org.jboss.webbeans.tck.impl.util.MockCreationalContext;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

@SuppressWarnings("unchecked")
public class AbstractTest
{

   protected abstract static class RunInDependentContext
   {

      protected void setup()
      {
         AbstractTest.activateDependentContext();
      }

      protected void cleanup()
      {
         AbstractTest.deactivateDependentContext();
      }

      public final void run() throws Exception
      {
         try
         {
            setup();
            execute();
         }
         finally
         {
            cleanup();
         }
      }

      protected abstract void execute() throws Exception;

   }

   private static final List<Class<? extends Annotation>> STANDARD_DEPLOYMENT_TYPES = Collections.unmodifiableList(Arrays.asList(Standard.class, Production.class));

   protected static final int BUILT_IN_BEANS = 3;

   protected Manager manager;

   public static boolean visited = false;

   @BeforeMethod
   public final void before()
   {
      if (getEnabledDeploymentTypes().size() > 0)
      {
         manager = configuration().getManagers().createManager(getEnabledDeploymentTypes());
      }
      else
      {
         manager = configuration().getManagers().createManager();
      }
   }

   @AfterMethod
   public void after()
   {
      manager = null;
   }

   @Deprecated
   public <T> Bean<T> createSimpleBean(Class<T> beanClass)
   {
      return configuration().getBeans().createSimpleBean(beanClass);
   }

   @Deprecated
   public <T> Bean<T> createEnterpriseBean(Class<T> beanClass)
   {
      return configuration().getBeans().createEnterpriseBean(beanClass);
   }

   @Deprecated
   public <T> Bean<T> createProducerMethodBean(Method method, Bean<?> producerBean)
   {
      return configuration().getBeans().createProducerMethodBean(method, producerBean);
   }

   @Deprecated
   public <T> Bean<T> createProducerFieldBean(Field field, Bean<?> producerBean)
   {
      return configuration().getBeans().createProducerFieldBean(field, producerBean);
   }

   protected void deployBeans(Class<?>... classes)
   {
      if (getEnabledDeploymentTypes().size() > 0)
      {
         manager = configuration().getContainers().deploy(getEnabledDeploymentTypes(), classes);
      }
      else
      {
         manager = configuration().getContainers().deploy(classes);
      }
   }

   protected final List<Class<? extends Annotation>> getStandardDeploymentTypes()
   {
      return new ArrayList<Class<? extends Annotation>>(STANDARD_DEPLOYMENT_TYPES);
   }

   /**
    * This method should be overridden by test classes which need to enable
    * additional deployment types beyond the normal ones.
    * 
    * @return the list of enabled deployment types
    */
   protected List<Class<? extends Annotation>> getEnabledDeploymentTypes()
   {
      return Collections.emptyList();
   }

   protected byte[] serialize(Object instance) throws IOException
   {
      ByteArrayOutputStream bytes = new ByteArrayOutputStream();
      ObjectOutputStream out = new ObjectOutputStream(bytes);
      out.writeObject(instance);
      return bytes.toByteArray();
   }

   protected Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException
   {
      ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
      return in.readObject();
   }

   protected static void activateDependentContext()
   {
      configuration().getContexts().setActive(configuration().getContexts().getDependentContext());
   }

   protected static void deactivateDependentContext()
   {
      configuration().getContexts().setInactive(configuration().getContexts().getDependentContext());
   }
   
   @Deprecated
   public static final <T> CreationalContext<T> mockCreationalContext(Class<T> expectedType)
   {
      return new MockCreationalContext<T>();
   }
}