package org.jboss.webbeans.tck.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import javax.xml.parsers.ParserConfigurationException;

import org.jboss.webbeans.tck.api.Beans;
import org.jboss.webbeans.tck.api.Containers;
import org.jboss.webbeans.tck.api.Contexts;
import org.jboss.webbeans.tck.api.Managers;
import org.jboss.webbeans.tck.api.TCKConfiguration;
import org.jboss.webbeans.tck.api.TestSuite;
import org.jboss.webbeans.tck.api.WebBeansTCK;
import org.jboss.webbeans.tck.impl.util.DeploymentProperties;
import org.testng.TestNG;
import org.testng.xml.Parser;
import org.testng.xml.XmlSuite;
import org.xml.sax.SAXException;

public class WebBeansTCKImpl extends WebBeansTCK
{
   
   private static TCKConfiguration configuration;
   
   public static TCKConfiguration configuration()
   {
      if (configuration == null)
      {
         configuration = createTCKConfiguration();
      }
      return configuration;
   }
   
   public WebBeansTCKImpl()
   {
      super();
      
   }
   
   @Override
   public boolean runUnitTests()
   {
      TestNG testNG = new TestNG();
      setXmlSuitePath(testNG);
      if (configuration.getTestSuite().getOutputDirectory() != null)
      {
         testNG.setOutputDirectory(configuration.getTestSuite().getOutputDirectory());
      }
      testNG.run();
      return !(testNG.hasFailure() || testNG.hasSkip());
   }
   
   private static void setXmlSuitePath(TestNG testNG)
   {
      InputStream is = WebBeansTCKImpl.class.getResourceAsStream("/tck-unit-tests.xml");
      if (is == null)
      {
         throw new IllegalStateException("Unable to load testng.xml");
      }
      List<XmlSuite> suites = new ArrayList<XmlSuite>();
      try
      {
         suites.addAll(new Parser(is).parse());
         
      }
      catch (ParserConfigurationException e)
      {
         throw new IllegalStateException("Unable to load testng.xml", e);
      }
      catch (SAXException e)
      {
         throw new IllegalStateException("Unable to load testng.xml", e);
      }
      catch (IOException e)
      {
         throw new IllegalStateException("Unable to load testng.xml", e);
      }
      testNG.setXmlSuites(suites);
   }

   @Override
   protected void configure(TCKConfiguration configuration)
   {
      if (configuration != null)
      {
         WebBeansTCKImpl.configuration = configuration;
      }
   }


   public static final TCKConfiguration createTCKConfiguration()
   {
      DeploymentProperties deploymentProperties = new DeploymentProperties();
      Managers managers = create(deploymentProperties.getClasses(Managers.PROPERTY_NAME, Managers.class), Managers.class, true);
      Containers containers = create(deploymentProperties.getClasses(Containers.PROPERTY_NAME, Containers.class), Containers.class, true);
      Beans beans = create(deploymentProperties.getClasses(Beans.PROPERTY_NAME, Beans.class), Beans.class, true);
      Contexts<?> contexts = create(deploymentProperties.getClasses(Contexts.PROPERTY_NAME, Contexts.class), Contexts.class, true);
      TestSuite testSuite = create(deploymentProperties.getClasses(TestSuite.PROPERTY_NAME, TestSuite.class), TestSuite.class, false);
      return TCKConfiguration.newInstance(beans, contexts, managers, containers, testSuite);
   }
   
   private static <T> T create(Set<Class<? extends T>> classes, Class<T> expectedType, boolean required)
   {
      if (classes.size() == 0)
      {
         if (required)
         {
            throw new IllegalArgumentException("Cannot find any implementations of " + expectedType.getSimpleName() + ", check that " + expectedType.getName() + " is specified");
         }
         else
         {
            return null;
         }
      }
      else if (classes.size() > 1)
      {
         throw new IllegalArgumentException("More than one implementation of " + expectedType.getSimpleName() + " specified, not sure which one to use!");
      }
      else
      {
         Class<? extends T> clazz = classes.iterator().next(); 
         try
         {
            return clazz.newInstance();
         }
         catch (InstantiationException e)
         {
            throw new IllegalStateException("Unable to instantiate " + clazz, e);
         }
         catch (IllegalAccessException e)
         {
            throw new IllegalStateException("Unable to instantiate " + clazz, e);
         }
      }
   }

}
