package org.jboss.webbeans.tck.integration.context.session;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 */
public class SessionContextTest extends AbstractTest
{

   /**
    * The session scope is active during the service() method of any servlet in
    * the web application
    */
   @Test(groups = { "stub", "contexts", "servlet" })
   @SpecAssertion(section = "8.5.2")
   public void testSessionScopeActiveDuringServiceMethod()
   {
      assert false;
   }

   /**
    * The session context is shared between all servlet requests that occur in
    * the same HTTP servlet session
    */
   @Test(groups = { "stub", "contexts", "servlet" })
   @SpecAssertion(section = "8.5.2")
   public void testSessionContextSharedBetweenServletRequestsInSameHttpSession()
   {
      assert false;
   }

   /**
    * The session context is destroyed when the HTTPSession is invalidated or
    * times out.
    */
   @Test(groups = { "stub", "contexts" })
   @SpecAssertion(section = "8.5.2")
   public void testSessionContextDestroyedWhenHttpSessionInvalidatedOrTimesOut()
   {
      assert false;
   }

}
