/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.webbeans.tck.integration.event;

import java.util.Set;

import javax.event.Observer;
import javax.inject.DefinitionException;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * Integration tests for Web Bean events.
 * 
 * @author David Allen
 * 
 * Spec version: PRD2
 * 
 */
public class EventTest extends AbstractTest
{
   @Test(groups = { "stub", "events", "integration" })
   @SpecAssertion(section = "7.4")
   public void testObserverCalledBeforeTransactionCompleteMaySetRollbackOnly()
   {
      assert false;
   }

   @Test(groups = { "stub", "events", "integration" })
   @SpecAssertion(section = "7.4")
   public void testObserverManipulatingJTATransactionsDirectlyFails()
   {
      assert false;
   }

   @Test(groups = { "events", "integration" })
   @SpecAssertion(section = "7.5")
   public void testObserverMethodOnEnterpriseBeanIsBusinessMethodOrStatic()
   {
      deployBeans(Pomeranian.class);
      Set<Bean<Object>> beans = manager.resolveByType(Object.class);
      assert beans.size() >= 2;
      Set<Observer<String>> observers = manager.resolveObservers("An event");
      assert observers.size() == 2;
   }

   @Test(groups = { "events", "integration" }, expectedExceptions=DefinitionException.class)
   @SpecAssertion(section = "7.5")
   public void testObserverMethodOnEnterpriseBeanNotBusinessMethodOrStaticFails()
   {
      deployBeans(TibetanTerrier.class);
      Set<Bean<Object>> beans = manager.resolveByType(Object.class);
      assert beans.size() >= 2;
      Set<Observer<String>> observers = manager.resolveObservers("An event");
   }

   /**
    * 
    */
   @Test(groups = { "events", "integration" , "broken"})
   @SpecAssertion(section = "7.5.8")
   public void testEnterpriseBeanObserverMethodCalledWithCallerContext()
   {
      deployBeans(Pomeranian.class);
      Set<Bean<Object>> beans = manager.resolveByType(Object.class);
      assert beans.size() >= 1;
      String event = "A new event";
      Set<Observer<String>> observers = manager.resolveObservers(event);
      assert observers.size() == 2;

      manager.fireEvent(event);
      assert Thread.currentThread().equals(Pomeranian.notificationThread);
   }

   @Test(groups = { "stub", "events", "integration" })
   @SpecAssertion(section = "7.5.8")
   public void testTransactionalObserverThrownExceptionIsCaughtAndLogged()
   {
      assert false;
   }

}
