package org.jboss.webbeans.tck.unit.definition.bean;

import java.lang.reflect.Method;

import javax.context.RequestScoped;
import javax.inject.Production;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * This test class should be used for common assertions about Web Beans
 * 
 * @author Pete Muir
 * 
 * Spec version: PRD2
 */
public class BeanDefinitionTest extends AbstractTest
{
   
   // TODO This should actually somehow test the reverse - that the container
   // throws a definition exception if any of these occur
   
   @Test
   @SpecAssertion(section = "2")
   public void testApiTypesNonEmpty()
   {
      Bean<?> model = createSimpleBean(RedSnapper.class);
      assert model.getTypes().size() > 0;
   }
   
   @Test
   @SpecAssertion(section = "2")
   public void testBindingTypesNonEmpty()
   {
      Bean<?> model = createSimpleBean(RedSnapper.class);
      assert model.getBindings().size() > 0;
   }
   
   @Test
   @SpecAssertion(section = "2")
   public void testHasScopeType()
   {
      Bean<?> model = createSimpleBean(RedSnapper.class);
      assert model.getScopeType().equals(RequestScoped.class);
   }
   
   @Test
   @SpecAssertion(section = "2")
   public void testHasDeploymentType()
   {
      Bean<?> model = createSimpleBean(RedSnapper.class);
      assert model.getDeploymentType().equals(Production.class);
   }
   
   @SuppressWarnings("unchecked")
   @Test(groups = "producerMethod")
   @SpecAssertion(section = "5.2")
   public void testIsNullable() throws Exception
   {
      Bean<SpiderProducer> spiderProducerBean = createSimpleBean(SpiderProducer.class);
      manager.addBean(spiderProducerBean);
      Method method = SpiderProducer.class.getMethod("getWolfSpiderSize");
      Bean<Integer> bean = createProducerMethodBean(method, spiderProducerBean);
      assert !bean.isNullable();
      method = SpiderProducer.class.getMethod("makeASpider");
      Bean<Spider> spiderBean = createProducerMethodBean(method, spiderProducerBean);
      assert spiderBean.isNullable();
   }
   
   @Test
   @SpecAssertion(section = { "3.2.2", "2.2" })
   public void testBeanTypes()
   {
      Bean<Tarantula> bean = createSimpleBean(Tarantula.class);
      assert bean.getTypes().size() == 6;
      assert bean.getTypes().contains(Tarantula.class);
      assert bean.getTypes().contains(Spider.class);
      assert bean.getTypes().contains(Animal.class);
      assert bean.getTypes().contains(Object.class);
      assert bean.getTypes().contains(DeadlySpider.class);
      assert bean.getTypes().contains(DeadlyAnimal.class);
   }
   
   @Test
   @SpecAssertion(section = "2.2")
   public void testFinalApiType()
   {
      createSimpleBean(DependentFinalTuna.class);
   }
   
}