package org.jboss.webbeans.tck.unit.definition.name;

import java.lang.annotation.Annotation;
import java.util.List;

import javax.inject.DefinitionException;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
public class NameDefinitionTest extends AbstractTest
{

   @Override
   protected List<Class<? extends Annotation>> getEnabledDeploymentTypes()
   {
      List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
      deploymentTypes.add(AnotherDeploymentType.class);
      return deploymentTypes;
   }
   
   @Test(groups="stub", expectedExceptions=DefinitionException.class) @SpecAssertion(section="2.6")
   public void testInvalidElIdentifierUsedAsWebBeanName()
   {
      assert false;
   }
   
   @Test @SpecAssertion(section="2.6.1")
   public void testNonDefaultNamed()
   {
      Bean<Moose> moose = createSimpleBean(Moose.class);
      assert moose.getName().equals("aMoose");
   }
   
   @Test(groups={"stub", "webbeansxml"}) @SpecAssertion(section="2.6.2")
   public void testNonDefaultXmlNamed()
   {
      /*Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
      annotations.put(Named.class, new NamedAnnotationLiteral(){
         
         public String value()
         {
            return "aTrout";
         }
         
      });
      AnnotatedClass<SeaBass> annotatedItem = new SimpleAnnotatedClass<SeaBass>(SeaBass.class, annotations);*/
      //SimpleBean<SeaBass> trout = createSimpleBean(SeaBass.class, annotatedItem, manager);
      
      //assert trout.getName().equals("aTrout");
      assert false;
   }
   
   @Test(groups={"stub", "webbeansxml"}) @SpecAssertion(section="2.6.2")
   public void testXmlNamedOverridesJavaNamed()
   {
      /*Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
      annotations.put(Named.class, new NamedAnnotationLiteral(){
         
         public String value()
         {
            return "aTrout";
         }
         
      });
      AnnotatedClass<Cod> annotatedItem = new SimpleAnnotatedClass<Cod>(Cod.class, annotations);*/
      //SimpleBean<Cod> cod = createSimpleBean(Cod.class, annotatedItem, manager);
      
      //assert cod.getName().equals("aTrout");
      assert false;
   }
   
   @Test(groups={"stub", "webbeansxml"}) @SpecAssertion(section={"2.6.2", "2.6.3"})
   public void testJavaNamedUsedWhenNoXmlSpecified()
   {
      //Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
      //AnnotatedClass<Cod> annotatedItem = new SimpleAnnotatedClass<Cod>(Cod.class, annotations);
      //SimpleBean<Cod> cod = createSimpleBean(Cod.class, annotatedItem, manager);
      
      //assert cod.getName().equals("whitefish");
      assert false;
   }
   
   @Test @SpecAssertion(section={"2.6.3", "3.2.7"})
   public void testDefaultNamed()
   {
      Bean<Haddock> haddock = createSimpleBean(Haddock.class);
      assert haddock.getName() != null;
      assert haddock.getName().equals("haddock");
   }
   
   @Test(groups={"stub", "webbeansxml"}) @SpecAssertion(section="2.6.3")
   public void testDefaultXmlNamed()
   {
      /*Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
      annotations.put(Named.class, new NamedAnnotationLiteral() {
         
         public String value()
         {
            return "";
         }
         
      });
      AnnotatedClass<SeaBass> annotatedItem = new SimpleAnnotatedClass<SeaBass>(SeaBass.class, annotations);*/
      //SimpleBean<SeaBass> trout = createSimpleBean(SeaBass.class, annotatedItem, manager);
      
      //assert trout.getName() != null;
      //assert trout.getName().equals("seaBass");
      assert false;
   }
   
   @Test @SpecAssertion(section={"2.6.3", "2.7"})
   public void testSterotypeDefaultsName()
   {
      Bean<RedSnapper> model = createSimpleBean(RedSnapper.class);
      assert model.getName().equals("redSnapper");
   }
   
   @Test @SpecAssertion(section="2.6.4")
   public void testNotNamedInJava()
   {
      Bean<SeaBass> model = createSimpleBean(SeaBass.class);
      assert model.getName() == null;
   }
   
   @Test @SpecAssertion(section="2.6.4")
   public void testNotNamedInXml()
   {
      Bean<SeaBass> model = createSimpleBean(SeaBass.class);
      assert model.getName() == null;
   }
   
   @Test @SpecAssertion(section="2.6.4")
   public void testNotNamedInStereotype()
   {
      Bean<Minnow> model = createSimpleBean(Minnow.class);
      assert model.getName() == null;
   }
   
}
