package org.jboss.webbeans.tck.unit.definition.scope;

import javax.context.ApplicationScoped;
import javax.context.Dependent;
import javax.context.RequestScoped;
import javax.inject.DefinitionException;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
public class ScopeDefinitionTest extends AbstractTest
{
   
   @Test @SpecAssertion(section="2.4")
   public void testScopeTypesAreExtensible()
   {
      Bean<Mullet> mullet = createSimpleBean(Mullet.class);
      assert mullet.getScopeType().equals(AnotherScopeType.class);
   }
   
   @Test(groups={"stub", "annotationDefinition"}) @SpecAssertion(section="2.4.2")
   public void testScopeTypeHasCorrectTarget()
   {
      assert false;
   }

   @Test(groups={"stub", "annotationDefinition"}) @SpecAssertion(section="2.4.2")
   public void testScopeTypeHasCorrectRetention()
   {
      assert false;
   }

   @Test(groups={"stub", "annotationDefinition"}) @SpecAssertion(section="2.4.2")
   public void testScopeTypeDeclaresScopeTypeAnnotation()
   {
      assert false;
   }
   
   @Test @SpecAssertion(section="2.4.3")
   public void testScopeDeclaredInJava()
   {
      Bean<SeaBass> trout = createSimpleBean(SeaBass.class);
      assert trout.getScopeType().equals(RequestScoped.class);
   }
   
   @Test(expectedExceptions=DefinitionException.class) @SpecAssertion(section="2.4.3")
   public void testTooManyScopesSpecifiedInJava()
   {
      createSimpleBean(BeanWithTooManyScopeTypes.class);
   }
   
   @Test(expectedExceptions=DefinitionException.class, groups={"stub", "webbeansxml"})
   public void testTooManyScopesSpecifiedInXml()
   {
      //Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
      //annotations.put(RequestScoped.class, new RequestScopedAnnotationLiteral());
      //annotations.put(ConversationScoped.class, new ConversationScopedAnnotationLiteral());
      //AnnotatedClass<Antelope> antelopeAnnotatedItem = new SimpleAnnotatedClass<Antelope>(Antelope.class, annotations);
      //createSimpleBean(null, antelopeAnnotatedItem, manager);
   }
   
   @Test(groups={"stub", "webbeansxml"}) @SpecAssertion(section="2.4.4")
   public void testScopeDeclaredInXml()
   {
      //Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
      //annotations.put(RequestScoped.class, new RequestScopedAnnotationLiteral());
      //AnnotatedClass<Order> annotatedItem = new SimpleAnnotatedClass<Order>(Order.class, annotations);
      
      //SimpleBean<Order> order = createSimpleBean(Order.class, annotatedItem, manager);
      //assert order.getScopeType().equals(RequestScoped.class);
      assert false;
   }
   
   @Test(groups={"stub", "webbeansxml"}) @SpecAssertion(section="2.4.4")
   public void testScopeMissingInXml()
   {
      //Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
      //AnnotatedClass<SeaBass> annotatedItem = new SimpleAnnotatedClass<SeaBass>(SeaBass.class, annotations);
      
      //SimpleBean<SeaBass> trout =createSimpleBean(SeaBass.class, annotatedItem, manager);
      //assert trout.getScopeType().equals(RequestScoped.class);
      assert false;
   }

   @Test(groups={"stub", "webbeansxml"}) @SpecAssertion(section="2.4.4")
   public void testScopeDeclaredInXmlOverridesJava()
   {
      //Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
      //annotations.put(ConversationScoped.class, new ConversationScopedAnnotationLiteral());
      //AnnotatedClass<SeaBass> annotatedItem = new SimpleAnnotatedClass<SeaBass>(SeaBass.class, annotations);
      //SimpleBean<SeaBass> trout = createSimpleBean(SeaBass.class, annotatedItem, manager);
      //assert trout.getScopeType().equals(ConversationScoped.class);
      assert false;
   }
   
   @Test @SpecAssertion(section="2.4.5")
   public void testDefaultScope()
   {
      Bean<Order> order = createSimpleBean(Order.class);
      assert order.getScopeType().equals(Dependent.class);
   }
   
   @Test @SpecAssertion(section={"2.4.5", "2.7.2"})
   public void testScopeSpecifiedAndStereotyped()
   {
      Bean<Minnow> minnow = createSimpleBean(Minnow.class);
      assert minnow.getScopeType().equals(RequestScoped.class);
   }
   
   @Test(expectedExceptions=DefinitionException.class) @SpecAssertion(section="2.4.5")
   public void testMutipleIncompatibleScopeStereotypes()
   {
      createSimpleBean(Scallop_Broken.class);
   }
   
   @Test @SpecAssertion(section="2.4.5")
   public void testMutipleIncompatibleScopeStereotypesWithScopeSpecified()
   {
      Bean<Pollock> pollock = createSimpleBean(Pollock.class);
      assert pollock.getScopeType().equals(Dependent.class);
   }
   
   @Test @SpecAssertion(section="2.4.5")
   public void testMutipleCompatibleScopeStereotypes()
   {
      Bean<Grayling> grayling = createSimpleBean(Grayling.class);
      assert grayling.getScopeType().equals(ApplicationScoped.class);
   }
   
   @Test @SpecAssertion(section={"2.7.2", "4.1"})
   public void testWebBeanScopeTypeOverridesStereotype()
   {
      Bean<RedSnapper> bean = createSimpleBean(RedSnapper.class);
      assert bean.getScopeType().equals(RequestScoped.class);
   }
   
   @Test @SpecAssertion(section="4.1")
   public void testScopeTypeDeclaredInheritedIsInherited() throws Exception
   {
      assert createSimpleBean(BorderCollie.class).getScopeType().equals(RequestScoped.class);
   }
   
   @Test @SpecAssertion(section="4.1")
   public void testScopeTypeNotDeclaredInheritedIsNotInherited()
   {
      assert createSimpleBean(ShetlandPony.class).getScopeType().equals(Dependent.class);
   }
   
   @Test @SpecAssertion(section="4.1")
   public void testScopeTypeDeclaredInheritedIsBlockedByIntermediateScopeTypeMarkedInherited()
   {
      assert createSimpleBean(GoldenRetriever.class).getScopeType().equals(ApplicationScoped.class);
   }
   
   @Test @SpecAssertion(section="4.1")
   public void testScopeTypeDeclaredInheritedIsBlockedByIntermediateScopeTypeNotMarkedInherited()
   {
      assert createSimpleBean(GoldenLabrador.class).getScopeType().equals(Dependent.class);
   }
   
}