package org.jboss.webbeans.tck.unit.implementation.enterprise;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * Sections
 * 
 * 3.3.5. Web Bean remove methods 3.3.5.1. Declaring a Web Bean remove method
 * using annotations. 3.3.5.2. Declaring a Web Bean remove method using XML
 * 3.3.5.3. Remove method parameters
 * 
 * @author Nicklas Karlsson
 * 
 * Spec version: PRD2
 */
public class EnterpriseBeanRemoveMethodTest extends AbstractTest
{

   /**
    * If the scope is @Dependent, the application may call any EJB remove method
    * of an instance of the enterprise Web Bean, but then no parameters will be
    * passed to the method by the Web Bean manager
    */
   @Test(groups = { "enterpriseBeans", "removeMethod", "lifecycle", "stub" })
   @SpecAssertion(section = "3.3.1")
   public void applicationMayCallRemoveMethodOnDependentScopedSessionEnterpriseBeansButNoParametersArePassed()
   {
      assert false;
   }

   /**
    * If the application directly calls an EJB remove method of an instance of
    * an enterprise Web Bean that is a stateful session bean and declares any
    * scope other than @Dependent, an UnsupportedOperationException is thrown.
    */
   @Test(groups = { "enterpriseBeans", "removeMethod", "lifecycle", "stub" }, expectedExceptions = UnsupportedOperationException.class)
   @SpecAssertion(section = "3.3.1")
   public void applicationCannotCallRemoveMethodOnNonDependentScopedSessionEnterpriseBean()
   {
      assert false;
   }

   /**
    * If the application directly calls an EJB remove method of an instance of
    * an enterprise Web Bean that is a stateful session bean and has scope
    * @Dependent, the Web Bean manager ignores the instance when instead of
    * destroying it
    */
   @Test(groups = { "enterpriseBeans", "removeMethod", "lifecycle", "stub" })
   @SpecAssertion(section = "3.3.1")
   public void applicationMayCallRemoveMethodOnDependentScopedSessionEnterpriseBeansButInstanceIsNotDestroyed()
   {
      assert false;
   }

}
