package org.jboss.webbeans.tck.unit.implementation.producer.method;

import java.lang.reflect.Method;

import javax.inject.CreationException;
import javax.inject.IllegalProductException;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.util.MockCreationalContext;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
public class ProducerMethodLifecycleTest extends AbstractTest
{
   
   @Test(groups={"producerMethod", "broken"}) @SpecAssertion(section="B.1")
   public void testProducerMethodBeanCreate() throws Exception
   {
      Bean<SpiderProducer> spiderProducer = createSimpleBean(SpiderProducer.class); 
      manager.addBean(spiderProducer);
      Method method = SpiderProducer.class.getMethod("produceTarantula");
      Bean<Tarantula> tarantulaBean = createProducerMethodBean(method, spiderProducer);
      Tarantula tarantula = tarantulaBean.create(new MockCreationalContext<Tarantula>());
      assert tarantula != null;
   }
   
   @Test(groups={"stub", "specialization"}) @SpecAssertion(section="3.3.4")
   public void testSpecializedBeanAlwaysUsed()
   {
      // TODO Placeholder
      assert false;
   }
   
   @Test(groups={"stub", "disposalMethod", "beanLifecycle"}) @SpecAssertion(section="3.3.5")
   public void testDisposalMethodCalled()
   {
      // TODO Placeholder
      assert false;
   }
   
   @Test(groups={"stub", "disposalMethod", "beanLifecycle"}) @SpecAssertion(section="3.3.5")
   public void testDisposalMethodHasParametersInjected()
   {
      // TODO Placeholder
      assert false;
   }
   
   
   @Test(groups={"producerMethod", "broken"}) 
   @SpecAssertion(section={"3.4", "B.1", "7.3"})
   public void testProducerMethodReturnsNullIsDependent() throws Exception
   {
      Bean<SpiderProducer> spiderProducer = createSimpleBean(SpiderProducer.class); 
      manager.addBean(spiderProducer);
      Method method = SpiderProducer.class.getMethod("getNullSpider");
      Bean<Spider> spiderBean = createProducerMethodBean(method, spiderProducer);
      Spider spider = spiderBean.create(new MockCreationalContext<Spider>());
      assert spider == null;
   }
   
   @Test(groups="producerMethod", expectedExceptions=IllegalProductException.class) 
   @SpecAssertion(section={"3.4", "B.1"})
   public void testProducerMethodReturnsNullIsNotDependent() throws Exception
   {
      Bean<SpiderProducer_Broken> spiderProducer = createSimpleBean(SpiderProducer_Broken.class);
      manager.addBean(spiderProducer);
      Method method = SpiderProducer_Broken.class.getMethod("getRequestScopedSpider");
      createProducerMethodBean(method, spiderProducer).create(new MockCreationalContext<Object>());
   }
   
   @Test(expectedExceptions=CreationException.class)
   public void testCreationExceptionWrapsCheckedExceptionThrownFromCreate() throws Exception
   {
      deployBeans(LorryProducer_Broken.class);
      new RunInDependentContext()
      {
         
         protected void execute() throws Exception 
         {
            manager.getInstanceByType(Lorry.class);
         }
         
      }.run();
   }
   
   @Test(expectedExceptions=FooException.class)
   public void testUncheckedExceptionThrownFromCreateNotWrapped() throws Exception
   {
      deployBeans(ShipProducer_Broken.class);
      new RunInDependentContext()
      {
         
         protected void execute() throws Exception 
         {
            manager.getInstanceByType(Ship.class);
         }
         
      }.run();
   }
   
}
