package org.jboss.webbeans.tck.unit.implementation.producer.method;

import javax.annotation.Named;
import javax.context.RequestScoped;
import javax.inject.Produces;
import javax.inject.Production;

@AnotherDeploymentType
class SpiderProducer
{
   
   private static Spider[] ALL_SPIDERS = { new Tarantula(), new LadybirdSpider(), new DaddyLongLegs() };
   
   @Produces @Tame public Tarantula produceTameTarantula()
   {
      return new DefangedTarantula();
   }
   
   @Produces public Tarantula produceTarantula()
   {
      return new Tarantula();
   }
   
   @Produces public Spider getNullSpider()
   {
      return null;
   }
   
   @Produces public FunnelWeaver<Spider> getFunnelWeaverSpider()
   {
      return new FunnelWeaver<Spider>();
   }
   
   @Produces public FunnelWeaver<?> getAnotherFunnelWeaver()
   {
      return new FunnelWeaver<Object>();
   }
   
   @Produces public <T> FunnelWeaver<T> getFunnelWeaver()
   {
      return new FunnelWeaver<T>();
   }
   
   @Produces public Animal makeASpider()
   {
      return new WolfSpider();
   }
   
   @Produces public int getWolfSpiderSize()
   {
      return 4;
   }
   
   @Produces public Spider[] getSpiders()
   {
      return ALL_SPIDERS;
   }
   
   @Produces @Named @RequestScoped public DaddyLongLegs produceDaddyLongLegs()
   {
      return new DaddyLongLegs();
   }

   @Produces @Named @Production public LadybirdSpider getLadybirdSpider()
   {
      return new LadybirdSpider();
   }

   @Produces @Named("blackWidow") public BlackWidow produceBlackWidow()
   {
      return new BlackWidow();
   }
   
   @Produces @AnimalStereotype public WolfSpider produceWolfSpider()
   {
      return new WolfSpider();
   }
   
}
