package org.jboss.webbeans.tck.unit.inheritance.realization;

import static org.jboss.webbeans.tck.impl.util.Reflections.annotationSetMatches;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

import javax.context.RequestScoped;
import javax.inject.AnnotationLiteral;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
public class RealizationTest extends AbstractTest
{
   
   private static Annotation SMELLY_LITERAL = new AnnotationLiteral<Smelly>(){}; 
      
   @Override
   protected List<Class<? extends Annotation>> getEnabledDeploymentTypes()
   {
      List<Class<? extends Annotation>> deploymentTypes = new ArrayList<Class<? extends Annotation>>();
      deploymentTypes.addAll(getStandardDeploymentTypes());
      deploymentTypes.add(AnotherDeploymentType.class);
      deploymentTypes.add(FarmAnimalDeploymentType.class);
      return deploymentTypes;
   }
   
   @Test @SpecAssertion(section="4.4")
   public void testRealizedBeanWithProducerMethodHasSameScope()
   {
      deployBeans(Cow.class);
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).size() == 1;
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).iterator().next().getScopeType().equals(RequestScoped.class);
   }
   
   @Test @SpecAssertion(section="4.4")
   public void testRealizedBeanWithProducerMethodHasDeploymentTypeOfRealizingClass()
   {
      deployBeans(Cow.class);
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).size() == 1;
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).iterator().next().getDeploymentType().equals(AnotherDeploymentType.class);
   }
   
   @Test @SpecAssertion(section="4.4")
   public void testRealizedBeanWithProducerMethodHasSameBindings()
   {
      deployBeans(Cow.class);
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).size() == 1;
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).iterator().next().getBindings().size() == 1;
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).iterator().next().getBindings().iterator().next().annotationType().equals(Smelly.class);
   }
   
   @Test@SpecAssertion(section="4.4")
   public void testRealizedBeanWithProducerMethodHasBindingsOfMethodAndRealizingType()
   {
      deployBeans(TameCow.class);
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).size() == 1;
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).iterator().next().getBindings().size() == 2;
      assert annotationSetMatches(manager.resolveByType(Dung.class, SMELLY_LITERAL).iterator().next().getBindings(), Smelly.class, Tame.class);
   }
   
   @Test @SpecAssertion(section="4.4")
   public void testRealizedBeanWithProducerMethodHasSameStereotypes()
   {
      deployBeans(LabradorKennel.class);
      assert manager.resolveByType(Dog.class).size() == 1;
      assert manager.resolveByType(Dog.class).iterator().next().getScopeType().equals(RequestScoped.class);
   }
   
   @Test(groups="stub") @SpecAssertion(section="4.1")
   public void testRealizedBeanWithProducerMethodHasSameInterceptorBindings()
   {
      assert false;
   }
   
   @Test @SpecAssertion(section="4.4")
   public void testRealizedBeanWithProducerFieldHasSameScope()
   {
      deployBeans(Horse.class);
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).size() == 1;
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).iterator().next().getScopeType().equals(RequestScoped.class);
   }
   
   @Test @SpecAssertion(section="4.4")
   public void testRealizedBeanWithProducerFieldHasDeploymentTypeOfRealizingClass()
   {
      deployBeans(Horse.class);
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).size() == 1;
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).iterator().next().getDeploymentType().equals(AnotherDeploymentType.class);
   }
   
   @Test @SpecAssertion(section="4.4")
   public void testRealizedBeanWithProducerFieldHasSameBindings()
   {
      deployBeans(Horse.class);
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).size() == 1;
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).iterator().next().getBindings().size() == 1;
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).iterator().next().getBindings().iterator().next().annotationType().equals(Smelly.class);
   }
   
   @Test @SpecAssertion(section="4.4")
   public void testRealizedBeanWithProducerFieldHasBindingsOfMethodAndRealizingType()
   {
      deployBeans(TameHorse.class);
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).size() == 1;
      assert manager.resolveByType(Dung.class, SMELLY_LITERAL).iterator().next().getBindings().size() == 2;
      assert annotationSetMatches(manager.resolveByType(Dung.class, SMELLY_LITERAL).iterator().next().getBindings(), Smelly.class, Tame.class);
   }
   
   @Test @SpecAssertion(section="4.4")
   public void testRealizedBeanWithProducerFieldHasSameStereotypes()
   {
      deployBeans(Stable.class);
      assert manager.resolveByType(Horse.class).size() == 1;
      assert manager.resolveByType(Horse.class).iterator().next().getScopeType().equals(RequestScoped.class);
   }
   
   @Test(groups="stub") @SpecAssertion(section="4.4")
   public void testRealizedBeanWithProducerFieldHasSameInterceptorBindings()
   {
      assert false;
   }
   
   @Test(groups="stub") @SpecAssertion(section="4.4")
   public void testDisposalMethodInherited()
   {
      assert false;
   }
   
   @Test(groups="stub") @SpecAssertion(section="4.4")
   public void testRealizedDisposalMethodHasBindingsOfMethodAndRealizingType()
   {
      assert false;
   }
   
   @Test @SpecAssertion(section="4.4")
   public void testObserverMethodInheritedAndHasSameBindings()
   {
      deployBeans(FarmHouse.class);
      assert manager.resolveObservers(new Cow(), new AnnotationLiteral<Tame>(){}).size() == 1;
      assert manager.resolveObservers(new Cow(), SMELLY_LITERAL).size() == 0;
   }
   
}
