package org.jboss.webbeans.tck.unit.inheritance.specialization.simple;

import static org.jboss.webbeans.tck.impl.util.Reflections.annotationSetMatches;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

import javax.inject.AnnotationLiteral;
import javax.inject.DefinitionException;
import javax.inject.InconsistentSpecializationException;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * Spec version: PRD2
 * 
 */
public class SimpleBeanSpecializationTest extends AbstractTest
{
   
   @Override
   protected List<Class<? extends Annotation>> getEnabledDeploymentTypes()
   {
      List<Class<? extends Annotation>> deploymentTypes = new ArrayList<Class<? extends Annotation>>();
      deploymentTypes.addAll(getStandardDeploymentTypes());
      deploymentTypes.add(AnotherDeploymentType.class);
      return deploymentTypes;
   }
   
   private static Annotation LANDOWNER_LITERAL = new AnnotationLiteral<Landowner>() {};

   @Test @SpecAssertion(section = {"4.3.1", "3.2.7"})
   public void testSpecializingBeanHasBindingsOfSpecializedAndSpecializingBean()
   {
      deployBeans(LazyFarmer.class);
      assert manager.resolveByType(Farmer.class, LANDOWNER_LITERAL).size() == 1;
      assert manager.resolveByType(Farmer.class, LANDOWNER_LITERAL).iterator().next().getTypes().contains(LazyFarmer.class);
      assert manager.resolveByType(Farmer.class, LANDOWNER_LITERAL).iterator().next().getBindings().size() == 2;
      assert annotationSetMatches( manager.resolveByType(Farmer.class, LANDOWNER_LITERAL).iterator().next().getBindings(), Landowner.class, Lazy.class);
   }
   
   @Test @SpecAssertion(section = {"4.3.1", "3.2.7"})
   public void testSpecializingBeanHasNameOfSpecializedBean()
   {
      deployBeans(LazyFarmer.class);
      assert manager.resolveByType(Farmer.class, LANDOWNER_LITERAL).size() == 1;
      assert manager.resolveByType(Farmer.class, LANDOWNER_LITERAL).iterator().next().getTypes().contains(LazyFarmer.class);
      assert manager.resolveByType(Farmer.class, LANDOWNER_LITERAL).iterator().next().getName().equals("farmer");
   }
   
   @Test(expectedExceptions=DefinitionException.class) @SpecAssertion(section = "4.3.1")
   public void testSpecializingAndSpecializedBeanHasName()
   {
      deployBeans(FarmYard_Broken.class);
   }
   
   @Test @SpecAssertion(section={"4.3.1", "3.2.7"})
   public void testSpecializedBeanNotInstantiated() throws Exception
   {
      deployBeans(LazyFarmer.class, Farmer.class);
      new RunInDependentContext()
      {
         
         @Override
         protected void execute() throws Exception
         {
            Farmer farmer = manager.getInstanceByType(Farmer.class, LANDOWNER_LITERAL);
            assert farmer.getClassName().equals(LazyFarmer.class.getName());
         }
         
      }.run();
   }
   
   @Test(expectedExceptions=InconsistentSpecializationException.class) 
   @SpecAssertion(section="4.3.1")
   public void testSpecializingBeanDoesNotHaveHigherPrecedenceThanSpecializedBean()
   {
      deployBeans(OrganicFarmer_Broken.class);
   }
   
   @Test @SpecAssertion(section="4.3.1")
   public void testProducerMethodOnSpecializedBeanCalledOnSpecializingBean() throws Exception
   {
      deployBeans(Office.class, Building.class);
      new RunInDependentContext()
      {
         
         @Override
         protected void execute() throws Exception
         {
            assert manager.resolveByType(Waste.class).size() == 1;
            assert manager.getInstanceByType(Waste.class).getFrom().equals(Office.class.getName());
         }
         
      }.run();
   }
   
   @Test(expectedExceptions=InconsistentSpecializationException.class) 
   @SpecAssertion(section="4.3.1")
   public void testTwoBeansSpecializeTheSameBean()
   {
      deployBeans(SheepFarmer_Broken.class, FishFarmer_Broken.class);
   }
   
   @Test(groups={"specialization"},expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.2.7")
   public void testSpecializingClassDirectlyExtendsEnterpriseBean()
   {
      deployBeans(FarmEquipment.class, Tractor_Broken.class);
   }
   
   @Test(groups={"specialization"},expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.2.7")
   public void testSpecializingClassDirectlyExtendsNothing()
   {
      deployBeans(Cow_Broken.class);
   }
   
   @Test(groups={"specialization"},expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.2.7")
   public void testSpecializingClassImplementsInterfaceAndExtendsNothing()
   {
      deployBeans(Donkey_Broken.class);
   }

}
