package org.jboss.webbeans.tck.unit.lookup.byname;

import javax.inject.AmbiguousDependencyException;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
public class InstantiationByNameTest extends AbstractTest
{
   
   @Test(groups="resolution") @SpecAssertion(section="5.10")
   public void testNoWebBeansFound() throws Exception
   {
      Bean<Cod> codBean = createSimpleBean(Cod.class);
      Bean<Salmon> salmonBean = createSimpleBean(Salmon.class);
      manager.addBean(codBean);
      manager.addBean(salmonBean);
      
      assert manager.getInstanceByName("foo") == null;
   }
   
   @Test(expectedExceptions=AmbiguousDependencyException.class) 
   @SpecAssertion(section="5.7.1")
   public void testAmbiguousDependencies() throws Exception
   {
      Bean<Cod> codBean = createSimpleBean(Cod.class);
      Bean<Salmon> salmonBean = createSimpleBean(Salmon.class);
      Bean<Sole> soleBean = createSimpleBean(Sole.class);
      manager.addBean(codBean);
      manager.addBean(salmonBean);
      manager.addBean(soleBean);
      
      manager.getInstanceByName("whitefish");
   }
   
   @Test(groups={"resolution", "beanLifecycle"}) @SpecAssertion(section="5.7.1")
   public void testGetInstanceByName()
   {
      Bean<Tuna> tunaBean = createSimpleBean(Tuna.class);
      Bean<Cod> codBean = createSimpleBean(Cod.class);
      Bean<Salmon> salmonBean = createSimpleBean(Salmon.class);
      Bean<Sole> soleBean = createSimpleBean(Sole.class);
      Bean<SeaBass> seaBassBean = createSimpleBean(SeaBass.class);
      Bean<Haddock> haddockBean = createSimpleBean(Haddock.class);
      Bean<Plaice> plaiceBean = createSimpleBean(Plaice.class);
      
      manager.addBean(tunaBean);
      manager.addBean(codBean);
      manager.addBean(salmonBean);
      manager.addBean(soleBean);
      manager.addBean(haddockBean);
      manager.addBean(seaBassBean);
      manager.addBean(plaiceBean);
      
      try
      {
         activateDependentContext();
         assert manager.getInstanceByName("salmon") instanceof Salmon;
      }
      finally
      {
         deactivateDependentContext();
      }
   }
   
   @Test(groups={"stub", "resolution", "el"}) @SpecAssertion(section="5.10")
   public void testGetInstanceByNameCalledOncePerDistinctNameInElExpression()
   {
      assert false;
   }
}
