/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.impl.util;

import java.io.IOException;
import java.net.URL;
import org.jboss.webbeans.tck.impl.util.EnumerationIterable;
import org.jboss.webbeans.tck.impl.util.ResourceLoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleResourceLoader {
    SimpleResourceLoader() {
    }

    public Class<?> classForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException(e);
        }
        catch (NoClassDefFoundError e) {
            throw new ResourceLoadingException(e);
        }
    }

    public URL getResource(String name) {
        return this.getClass().getResource(name);
    }

    public Iterable<URL> getResources(String name) {
        try {
            return new EnumerationIterable<URL>(this.getClass().getClassLoader().getResources(name));
        }
        catch (IOException e) {
            throw new ResourceLoadingException(e);
        }
    }
}

