/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.context;

import java.lang.annotation.Annotation;
import javax.context.Context;
import javax.context.ContextNotActiveException;
import javax.context.Contextual;
import javax.context.CreationalContext;
import javax.context.RequestScoped;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.WebBeansTCKImpl;
import org.testng.annotations.Test;

public class ContextTest
extends AbstractTest {
    @Test(expectedExceptions={ContextNotActiveException.class}, groups={"manager"})
    @SpecAssertion(section={"8.5"})
    public void testGetContextWithNoActiveContextsFails() {
        WebBeansTCKImpl.configuration().getContexts().setInactive(WebBeansTCKImpl.configuration().getContexts().getRequestContext());
        this.manager.getContext(RequestScoped.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, groups={"manager"})
    @SpecAssertion(section={"8.5"})
    public void testGetContextWithTooManyActiveContextsFails() {
        DummyContext firstContext = new DummyContext(){};
        DummyContext secondContext = new DummyContext(){};
        this.manager.addContext((Context)firstContext);
        this.manager.addContext((Context)secondContext);
        this.manager.getContext(Dummy.class);
    }

    @Test(expectedExceptions={ContextNotActiveException.class}, groups={"manager"})
    @SpecAssertion(section={"8.5"})
    public void testGetContextWithNoRegisteredContextsFails() {
        this.manager.getContext(Unregistered.class);
    }

    @Test(groups={"manager"})
    @SpecAssertion(section={"8.5"})
    public void testGetContextReturnsActiveContext() {
        this.manager.getContext(RequestScoped.class);
    }

    @Test(groups={"stub", "contexts"})
    @SpecAssertion(section={"8.5"})
    public void testBuiltInNormalScopedContextsPropagateAcrossAnyJavaMethodCall() {
        assert (false);
    }

    @Test(groups={"stub", "contexts"})
    @SpecAssertion(section={"8.5"})
    public void testBuiltInNormalScopedContextsDoNotPropagateAcrossRemoteMethodInvocations() {
        assert (false);
    }

    @Test(groups={"stub", "contexts"})
    @SpecAssertion(section={"8.5"})
    public void testBuiltInNormalScopedContextsDoNotPropagateAcrossAsynchronousMethodInvocations() {
        assert (false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyContext
    implements Context {
        private DummyContext() {
        }

        public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
            throw new UnsupportedOperationException();
        }

        public <T> T get(Contextual<T> contextual) {
            return this.get(contextual, null);
        }

        public Class<? extends Annotation> getScopeType() {
            return Dummy.class;
        }

        public boolean isActive() {
            return true;
        }
    }

    private static @interface Unregistered {
    }

    private static @interface Dummy {
    }
}

