/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.context.passivating;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.inject.DefinitionException;
import javax.inject.IllegalProductException;
import javax.inject.UnserializableDependencyException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.unit.context.passivating.CityProducer;
import org.jboss.webbeans.tck.unit.context.passivating.CityProducer2;
import org.jboss.webbeans.tck.unit.context.passivating.Espoo_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.FooConsumer;
import org.jboss.webbeans.tck.unit.context.passivating.Forssa_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.Generator;
import org.jboss.webbeans.tck.unit.context.passivating.Hamina_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.Helsinki;
import org.jboss.webbeans.tck.unit.context.passivating.Hyvinkaa;
import org.jboss.webbeans.tck.unit.context.passivating.Jamsa_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.Joensuu;
import org.jboss.webbeans.tck.unit.context.passivating.Jyvaskyla;
import org.jboss.webbeans.tck.unit.context.passivating.Kaarina_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.Kotka_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.Kuopio_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.Loviisa_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.Maarianhamina_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.Mikkeli_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.Nokia_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.NumberConsumer;
import org.jboss.webbeans.tck.unit.context.passivating.Peraseinajoki;
import org.jboss.webbeans.tck.unit.context.passivating.Porvoo_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.Raisio_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.Salo_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.Uusikaupunki_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.Vaasa;
import org.jboss.webbeans.tck.unit.context.passivating.Vantaa_Broken;
import org.jboss.webbeans.tck.unit.context.passivating.Violation;
import org.jboss.webbeans.tck.unit.context.passivating.Violation2;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PassivatingContextTest
extends AbstractTest {
    @Test(groups={"contexts", "passivation"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"8.4"})
    public void testSimpleWebBeanWithNonSerializableImplementationClassFails() {
        this.deployBeans(Hamina_Broken.class);
    }

    @Test(groups={"contexts", "passivation"})
    @SpecAssertion(section={"8.4"})
    public void testSimpleWebBeanWithSerializableImplementationClassOK() {
        this.createSimpleBean(Jyvaskyla.class);
    }

    @Test
    @SpecAssertion(section={"8.4"})
    public void testInjectionOfDependentSerializableProductIntoNormalBean() {
        this.deployBeans(Generator.class, NumberConsumer.class);
        ((NumberConsumer)this.manager.getInstanceByType(NumberConsumer.class, new Annotation[0])).ping();
    }

    @Test
    @SpecAssertion(section={"8.4"})
    public void testInjectionOfDependentPrimitiveProductIntoNormalBean() {
        this.deployBeans(Generator.class, FooConsumer.class);
        ((FooConsumer)this.manager.getInstanceByType(FooConsumer.class, new Annotation[0])).ping();
    }

    @Test(groups={"contexts", "passivation", "stub"})
    @SpecAssertion(section={"8.4"})
    public void testSimpleWebBeanDeclaringPassivatingScopeIsSerializedWhenContextIsPassivated() throws IOException, ClassNotFoundException {
        assert (false);
    }

    private <T> boolean testSerialize(Bean<T> bean) throws IOException, ClassNotFoundException {
        this.manager.addBean(bean);
        Object instance = this.manager.getInstance(bean);
        byte[] data = this.serialize(instance);
        Object resurrected = this.deserialize(data);
        return resurrected.toString().equals(instance.toString());
    }

    @Test(groups={"contexts", "passivation", "broken", "stub"})
    @SpecAssertion(section={"8.4"})
    public void testStatefulEJBIsSerializedWhenPassivatedByEJBContainer() throws IOException, ClassNotFoundException {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "passivation"}, expectedExceptions={UnserializableDependencyException.class})
    @SpecAssertion(section={"8.4"})
    public void testDependentInterceptorsOfStatefulEnterpriseBeanMustBeSerializable() {
        this.deployBeans(Kaarina_Broken.class);
    }

    @Test(groups={"stub", "contexts", "passivation"}, expectedExceptions={UnserializableDependencyException.class})
    @SpecAssertion(section={"8.4"})
    public void testDependentDecoratorsOfStatefulEnterpriseBeanMustBeSerializable() {
        this.deployBeans(Porvoo_Broken.class);
    }

    @Test(groups={"stub", "contexts", "passivation"}, expectedExceptions={UnserializableDependencyException.class})
    @SpecAssertion(section={"8.4"})
    public void testDependentInterceptorsOfWebBeanWithPassivatingScopeMustBeSerializable() {
        this.deployBeans(Kotka_Broken.class);
    }

    @Test(groups={"stub", "contexts", "passivation"}, expectedExceptions={UnserializableDependencyException.class})
    @SpecAssertion(section={"8.4"})
    public void testDependentDecoratorsOfWebBeansWithPassivatingScopeMustBeSerializable() {
        this.deployBeans(Raisio_Broken.class);
    }

    @Test(groups={"contexts", "passivation"})
    @SpecAssertion(section={"8.4"})
    public void testDependentEJBsAreSerializable() throws IOException, ClassNotFoundException {
        this.deployBeans(Vaasa.class, Helsinki.class);
        Set vaasaBeans = this.manager.resolveByType(Vaasa.class, new Annotation[0]);
        assert (vaasaBeans.size() == 1);
        assert (this.testSerialize((Bean)vaasaBeans.iterator().next()));
    }

    @Test(groups={"stub", "contexts", "passivation"}, expectedExceptions={UnserializableDependencyException.class})
    @SpecAssertion(section={"8.4"})
    public void testSimpleDependentWebBeanWithNonSerializableImplementationInjectedIntoStatefulSessionBeanFails() {
        this.deployBeans(Violation.class, Espoo_Broken.class);
        this.manager.getInstanceByType(Espoo_Broken.class, new Annotation[0]);
    }

    @Test(groups={"contexts", "passivation"}, expectedExceptions={UnserializableDependencyException.class})
    @SpecAssertion(section={"8.4"})
    public void testSimpleDependentWebBeanWithNonSerializableImplementationInjectedIntoNonTransientFieldOfWebBeanWithPassivatingScopeFails() {
        this.deployBeans(Vantaa_Broken.class, Violation.class);
    }

    @Test(groups={"contexts", "passivation"})
    @SpecAssertion(section={"8.4"})
    public void testSimpleDependentWebBeanWithNonSerializableImplementationInjectedIntoTransientFieldOK() {
        this.createSimpleBean(Joensuu.class);
    }

    @Test(groups={"contexts", "passivation"}, expectedExceptions={UnserializableDependencyException.class})
    @SpecAssertion(section={"8.4"})
    public void testSimpleDependentWebBeanWithNonSerializableImplementationInjectedIntoConstructorParameterOfWebBeanWithPassivatingScopeFails() {
        this.deployBeans(Loviisa_Broken.class, Violation.class);
    }

    @Test(groups={"contexts", "passivation"}, expectedExceptions={UnserializableDependencyException.class})
    @SpecAssertion(section={"8.4"})
    public void testSimpleDependentWebBeanWithNonSerializableImplementationInjectedIntoInitializerParameterOfWebBeanWithPassivatingScopeFails() {
        this.deployBeans(Forssa_Broken.class, Violation.class);
    }

    @Test(groups={"contexts", "passivation"}, expectedExceptions={UnserializableDependencyException.class})
    @SpecAssertion(section={"8.4"})
    public void testSimpleDependentWebBeanWithNonSerializableImplementationInjectedIntoProducerMethodParameterWithPassivatingScopeFails() {
        this.deployBeans(Peraseinajoki.class, Violation.class, Violation2.class);
    }

    @Test(groups={"contexts", "passivation", "integration", "broken"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section={"8.4"})
    public void testDependentScopedProducerMethodReturnsNonSerializableObjectForInjectionIntoStatefulSessionBeanFails() throws SecurityException, NoSuchMethodException {
        this.deployBeans(CityProducer2.class, Maarianhamina_Broken.class);
        this.manager.getInstanceByType(Maarianhamina_Broken.class, new Annotation[0]);
    }

    @Test(groups={"contexts", "passivation"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section={"8.4"})
    public void testDependentScopedProducerMethodReturnsNonSerializableObjectForInjectionIntoNonTransientFieldOfWebBeanWithPassivatingScopeFails() {
        this.deployBeans(CityProducer2.class, Nokia_Broken.class);
        ((Nokia_Broken)this.manager.getInstanceByType(Nokia_Broken.class, new Annotation[0])).ping();
    }

    @Test(groups={"contexts", "passivation"})
    @SpecAssertion(section={"8.4"})
    public void testDependentScopedProducerMethodReturnsNonSerializableObjectForInjectionIntoTransientFieldOfWebBeanWithPassivatingScopeOK() {
        this.createSimpleBean(CityProducer2.class);
        this.createSimpleBean(Hyvinkaa.class);
    }

    @Test(groups={"contexts", "passivation"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section={"8.4"})
    public void testDependentScopedProducerMethodReturnsNonSerializableObjectForInjectionIntoConstructorParameterOfWebBeanWithPassivatingScopeFails() {
        this.deployBeans(CityProducer2.class, Loviisa_Broken.class);
        ((Loviisa_Broken)this.manager.getInstanceByType(Loviisa_Broken.class, new Annotation[0])).ping();
    }

    @Test(groups={"contexts", "passivation"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section={"8.4"})
    public void testDependentScopedProducerMethodReturnsNonSerializableObjectForInjectionIntoInitializerParameterOfWebBeanWithPassivatingScopeFails() {
        this.deployBeans(CityProducer2.class, Kuopio_Broken.class);
        ((Kuopio_Broken)this.manager.getInstanceByType(Kuopio_Broken.class, new Annotation[0])).ping();
    }

    @Test(groups={"contexts", "passivation"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section={"8.4"})
    public void testDependentScopedProducerMethodReturnsNonSerializableObjectForInjectionIntoProducerMethodParameterWithPassivatingScopeFails() {
        this.deployBeans(CityProducer2.class, Jamsa_Broken.class);
        ((Jamsa_Broken)this.manager.getInstanceByType(Jamsa_Broken.class, new Annotation[0])).ping();
    }

    @Test(groups={"contexts", "passivation", "stub"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section={"8.4"})
    public void testDependentScopedProducerFieldReturnsNonSerializableObjectForInjectionIntoStatefulSessionBeanFails() throws Exception {
        assert (false);
    }

    @Test(groups={"contexts", "passivation"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section={"8.4"})
    public void testDependentScopedProducerFieldReturnsNonSerializableObjectForInjectionIntoNonTransientFieldOfWebBeanWithPassivatingScopeFails() {
        this.deployBeans(CityProducer.class, Uusikaupunki_Broken.class);
        ((Uusikaupunki_Broken)this.manager.getInstanceByType(Uusikaupunki_Broken.class, new Annotation[0])).ping();
    }

    @Test(groups={"contexts", "passivation"})
    @SpecAssertion(section={"8.4"})
    public void testDependentScopedProducerFieldReturnsNonSerializableObjectForInjectionIntoTransientFieldOfWebBeanWithPassivatingScopeOK() {
        this.deployBeans(CityProducer.class, Salo_Broken.class);
        ((Salo_Broken)this.manager.getInstanceByType(Salo_Broken.class, new Annotation[0])).ping();
    }

    @Test(groups={"contexts", "passivation"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section={"8.4"})
    public void testDependentScopedProducerFieldReturnsNonSerializableObjectForInjectionIntoConstructorParameterOfWebBeanWithPassivatingScopeFails() {
        this.deployBeans(CityProducer.class, Loviisa_Broken.class);
        ((Loviisa_Broken)this.manager.getInstanceByType(Loviisa_Broken.class, new Annotation[0])).ping();
    }

    @Test(groups={"contexts", "passivation"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section={"8.4"})
    public void testDependentScopedProducerFieldReturnsNonSerializableObjectForInjectionIntoInitializerParameterOfWebBeanWithPassivatingScopeFails() {
        this.deployBeans(CityProducer.class, Mikkeli_Broken.class);
        ((Mikkeli_Broken)this.manager.getInstanceByType(Mikkeli_Broken.class, new Annotation[0])).ping();
    }

    @Test(groups={"contexts", "passivation"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section={"8.4"})
    public void testDependentScopedProducerFieldReturnsNonSerializableObjectForInjectionIntoProducerMethodParameterWithPassivatingScopeFails() {
        this.deployBeans(CityProducer.class, Jamsa_Broken.class);
        ((Jamsa_Broken)this.manager.getInstanceByType(Jamsa_Broken.class, new Annotation[0])).ping();
    }
}

