/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.definition.scope;

import javax.context.ApplicationScoped;
import javax.context.Dependent;
import javax.context.RequestScoped;
import javax.inject.DefinitionException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.unit.definition.scope.AnotherScopeType;
import org.jboss.webbeans.tck.unit.definition.scope.BeanWithTooManyScopeTypes;
import org.jboss.webbeans.tck.unit.definition.scope.BorderCollie;
import org.jboss.webbeans.tck.unit.definition.scope.GoldenLabrador;
import org.jboss.webbeans.tck.unit.definition.scope.GoldenRetriever;
import org.jboss.webbeans.tck.unit.definition.scope.Grayling;
import org.jboss.webbeans.tck.unit.definition.scope.Minnow;
import org.jboss.webbeans.tck.unit.definition.scope.Mullet;
import org.jboss.webbeans.tck.unit.definition.scope.Order;
import org.jboss.webbeans.tck.unit.definition.scope.Pollock;
import org.jboss.webbeans.tck.unit.definition.scope.RedSnapper;
import org.jboss.webbeans.tck.unit.definition.scope.Scallop_Broken;
import org.jboss.webbeans.tck.unit.definition.scope.SeaBass;
import org.jboss.webbeans.tck.unit.definition.scope.ShetlandPony;
import org.testng.annotations.Test;

public class ScopeDefinitionTest
extends AbstractTest {
    @Test
    @SpecAssertion(section={"2.4"})
    public void testScopeTypesAreExtensible() {
        Bean<Mullet> mullet = this.createSimpleBean(Mullet.class);
        assert (mullet.getScopeType().equals(AnotherScopeType.class));
    }

    @Test(groups={"stub", "annotationDefinition"})
    @SpecAssertion(section={"2.4.2"})
    public void testScopeTypeHasCorrectTarget() {
        assert (false);
    }

    @Test(groups={"stub", "annotationDefinition"})
    @SpecAssertion(section={"2.4.2"})
    public void testScopeTypeHasCorrectRetention() {
        assert (false);
    }

    @Test(groups={"stub", "annotationDefinition"})
    @SpecAssertion(section={"2.4.2"})
    public void testScopeTypeDeclaresScopeTypeAnnotation() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"2.4.3"})
    public void testScopeDeclaredInJava() {
        Bean<SeaBass> trout = this.createSimpleBean(SeaBass.class);
        assert (trout.getScopeType().equals(RequestScoped.class));
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.4.3"})
    public void testTooManyScopesSpecifiedInJava() {
        this.createSimpleBean(BeanWithTooManyScopeTypes.class);
    }

    @Test(expectedExceptions={DefinitionException.class}, groups={"stub", "webbeansxml"})
    public void testTooManyScopesSpecifiedInXml() {
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.4.4"})
    public void testScopeDeclaredInXml() {
        assert (false);
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.4.4"})
    public void testScopeMissingInXml() {
        assert (false);
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.4.4"})
    public void testScopeDeclaredInXmlOverridesJava() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"2.4.5"})
    public void testDefaultScope() {
        Bean<Order> order = this.createSimpleBean(Order.class);
        assert (order.getScopeType().equals(Dependent.class));
    }

    @Test
    @SpecAssertion(section={"2.4.5", "2.7.2"})
    public void testScopeSpecifiedAndStereotyped() {
        Bean<Minnow> minnow = this.createSimpleBean(Minnow.class);
        assert (minnow.getScopeType().equals(RequestScoped.class));
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.4.5"})
    public void testMutipleIncompatibleScopeStereotypes() {
        this.createSimpleBean(Scallop_Broken.class);
    }

    @Test
    @SpecAssertion(section={"2.4.5"})
    public void testMutipleIncompatibleScopeStereotypesWithScopeSpecified() {
        Bean<Pollock> pollock = this.createSimpleBean(Pollock.class);
        assert (pollock.getScopeType().equals(Dependent.class));
    }

    @Test
    @SpecAssertion(section={"2.4.5"})
    public void testMutipleCompatibleScopeStereotypes() {
        Bean<Grayling> grayling = this.createSimpleBean(Grayling.class);
        assert (grayling.getScopeType().equals(ApplicationScoped.class));
    }

    @Test
    @SpecAssertion(section={"2.7.2", "4.1"})
    public void testWebBeanScopeTypeOverridesStereotype() {
        Bean<RedSnapper> bean = this.createSimpleBean(RedSnapper.class);
        assert (bean.getScopeType().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section={"4.1"})
    public void testScopeTypeDeclaredInheritedIsInherited() throws Exception {
        assert (this.createSimpleBean(BorderCollie.class).getScopeType().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section={"4.1"})
    public void testScopeTypeNotDeclaredInheritedIsNotInherited() {
        assert (this.createSimpleBean(ShetlandPony.class).getScopeType().equals(Dependent.class));
    }

    @Test
    @SpecAssertion(section={"4.1"})
    public void testScopeTypeDeclaredInheritedIsBlockedByIntermediateScopeTypeMarkedInherited() {
        assert (this.createSimpleBean(GoldenRetriever.class).getScopeType().equals(ApplicationScoped.class));
    }

    @Test
    @SpecAssertion(section={"4.1"})
    public void testScopeTypeDeclaredInheritedIsBlockedByIntermediateScopeTypeNotMarkedInherited() {
        assert (this.createSimpleBean(GoldenLabrador.class).getScopeType().equals(Dependent.class));
    }
}

