/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.definition.stereotype;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.context.ApplicationScoped;
import javax.context.Dependent;
import javax.context.RequestScoped;
import javax.inject.DefinitionException;
import javax.inject.Production;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.unit.definition.stereotype.Animal;
import org.jboss.webbeans.tck.unit.definition.stereotype.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.definition.stereotype.Antelope_Broken;
import org.jboss.webbeans.tck.unit.definition.stereotype.BorderCollie;
import org.jboss.webbeans.tck.unit.definition.stereotype.Carp_Broken;
import org.jboss.webbeans.tck.unit.definition.stereotype.Chair_Broken;
import org.jboss.webbeans.tck.unit.definition.stereotype.Elk_Broken;
import org.jboss.webbeans.tck.unit.definition.stereotype.FallowDeer_Broken;
import org.jboss.webbeans.tck.unit.definition.stereotype.Gazelle_Broken;
import org.jboss.webbeans.tck.unit.definition.stereotype.Goat_Broken;
import org.jboss.webbeans.tck.unit.definition.stereotype.Goldfish;
import org.jboss.webbeans.tck.unit.definition.stereotype.HighlandCow;
import org.jboss.webbeans.tck.unit.definition.stereotype.HornedAnimalDeploymentType;
import org.jboss.webbeans.tck.unit.definition.stereotype.Moose;
import org.jboss.webbeans.tck.unit.definition.stereotype.Reindeer;
import org.jboss.webbeans.tck.unit.definition.stereotype.RoeDeer_Broken;
import org.jboss.webbeans.tck.unit.definition.stereotype.ShetlandPony;
import org.jboss.webbeans.tck.unit.definition.stereotype.Springbok;
import org.jboss.webbeans.tck.unit.definition.stereotype.Tame;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeDefinitionTest
extends AbstractTest {
    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
        deploymentTypes.add(AnotherDeploymentType.class);
        deploymentTypes.add(HornedAnimalDeploymentType.class);
        return deploymentTypes;
    }

    @Test(groups={"stub", "annotationDefinition"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.7.1"})
    public void testHasCorrectTarget() {
        assert (false);
    }

    @Test(groups={"stub", "annotationDefinition"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.7.1"})
    public void testHasCorrectRetention() {
        assert (false);
    }

    @Test(groups={"stub", "annotationDefinition"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.7.1"})
    public void testHasStereotypeAnnotation() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"2.7.1.1"})
    public void testStereotypeWithScopeType() {
        Bean<Moose> moose = this.createSimpleBean(Moose.class);
        assert (moose.getScopeType().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section={"2.7.1.1"})
    public void testStereotypeWithoutScopeType() {
        Bean<Reindeer> reindeer = this.createSimpleBean(Reindeer.class);
        assert (reindeer.getScopeType().equals(Dependent.class));
    }

    @Test(groups={"stub"})
    @SpecAssertion(section={"2.7.1.2"})
    public void testStereotypeWithoutInterceptors() {
        assert (false);
    }

    @Test(groups={"stub", "interceptors"})
    @SpecAssertion(section={"2.7.1.2"})
    public void testStereotypeWithInterceptors() {
        assert (false);
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.7.1.1"})
    public void testStereotypeWithTooManyScopeTypes() {
        this.deployBeans(Elk_Broken.class);
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.7.1.1"})
    public void testStereotypeWithTooManyDeploymentTypes() {
        this.deployBeans(Gazelle_Broken.class);
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.7.1.3"})
    public void testStereotypeWithNonEmptyNamed() {
        this.deployBeans(FallowDeer_Broken.class);
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.7.1"})
    public void testStereotypeWithBindingTypes() {
        this.deployBeans(RoeDeer_Broken.class);
    }

    @Test
    @SpecAssertion(section={"2.7.2", "2.7.4"})
    public void testMultipleStereotypes() {
        Bean<HighlandCow> highlandCow = this.createSimpleBean(HighlandCow.class);
        assert (highlandCow.getName() == null);
        assert (((Annotation)highlandCow.getBindings().iterator().next()).annotationType().equals(Tame.class));
        assert (highlandCow.getScopeType().equals(RequestScoped.class));
        assert (highlandCow.getDeploymentType().equals(HornedAnimalDeploymentType.class));
    }

    @Test
    @SpecAssertion(section={"2.7.2", "2.7.4"})
    public void testMultipleStereotypesMergesScopes() {
        Bean<Springbok> springbok = this.createSimpleBean(Springbok.class);
        assert (springbok.getScopeType().equals(ApplicationScoped.class));
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.7.2", "2.7.4"})
    public void testMultipleStereotypesMergesRequiredTypes() {
        this.deployBeans(Antelope_Broken.class);
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.7.2", "2.7.4"})
    public void testMultipleStereotypesWithMultipleDeploymentTypes() {
        this.deployBeans(Goat_Broken.class);
    }

    @Test(expectedExceptions={DefinitionException.class}, groups={"stub"})
    @SpecAssertion(section={"2.7.2", "2.7.4"})
    public void testMultipleStereotypesWithMultipleScopeTypes() {
        assert (false);
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.7.3"})
    public void testStereotypeDeclaredInXmlIgnoresJavaStereotypes() {
        assert (false);
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.7.3"})
    public void testStereotypeDeclaredInXmlIgnoresJavaBindingTypes() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"2.7.1.4", "2.7.4"})
    public void testRequiredTypeIsImplemented() {
        assert (this.createSimpleBean(HighlandCow.class).getTypes().contains(Animal.class));
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.7.1.4", "2.7.4"})
    public void testRequiredTypeIsNotImplemented() {
        this.deployBeans(Chair_Broken.class);
    }

    @Test
    @SpecAssertion(section={"2.7.1.4", "2.7.4"})
    public void testScopeIsSupported() {
        assert (this.createSimpleBean(Goldfish.class).getScopeType().equals(RequestScoped.class));
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.7.1.4", "2.7.4"})
    public void testScopeIsNotSupported() {
        this.createSimpleBean(Carp_Broken.class);
    }

    @Test
    @SpecAssertion(section={"4.1"})
    public void testStereotypeDeclaredInheritedIsInherited() throws Exception {
        assert (this.createSimpleBean(BorderCollie.class).getScopeType().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section={"4.1"})
    public void testStereotypeNotDeclaredInheritedIsNotInherited() {
        assert (this.createSimpleBean(ShetlandPony.class).getDeploymentType().equals(Production.class));
    }
}

