/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.implementation.producer.field;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.context.RequestScoped;
import javax.inject.DefinitionException;
import javax.inject.Production;
import javax.inject.Standard;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.literals.CurrentBinding;
import org.jboss.webbeans.tck.unit.implementation.producer.field.Animal;
import org.jboss.webbeans.tck.unit.implementation.producer.field.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.implementation.producer.field.BlackWidowProducer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.DeadlyAnimal;
import org.jboss.webbeans.tck.unit.implementation.producer.field.DeadlySpider;
import org.jboss.webbeans.tck.unit.implementation.producer.field.Egg;
import org.jboss.webbeans.tck.unit.implementation.producer.field.FunnelWeaverSpiderConsumer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.FunnelWeaverSpiderProducer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.InfertileChicken;
import org.jboss.webbeans.tck.unit.implementation.producer.field.OtherSpiderProducer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.Spider;
import org.jboss.webbeans.tck.unit.implementation.producer.field.SpiderAsAnimalProducer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.SpiderProducerWildCardType_Broken;
import org.jboss.webbeans.tck.unit.implementation.producer.field.StaticTarantulaProducer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.Tame;
import org.jboss.webbeans.tck.unit.implementation.producer.field.TameAnnotationLiteral;
import org.jboss.webbeans.tck.unit.implementation.producer.field.TameTarantulaProducer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.Tarantula;
import org.jboss.webbeans.tck.unit.implementation.producer.field.TarantulaConsumer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.TarantulaProducer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.VibratingSpiderImpl_Broken;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerFieldDefinitionTest
extends AbstractTest {
    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        return Collections.unmodifiableList(Arrays.asList(Standard.class, Production.class, AnotherDeploymentType.class));
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"2.5.3"})
    public void testProducerFieldInheritsDeploymentTypeOfDeclaringWebBean() throws Exception {
        this.deployBeans(TarantulaProducer.class, TarantulaConsumer.class);
        Set tarantulaBeans = this.manager.resolveByType(Tarantula.class, new Annotation[0]);
        assert (!tarantulaBeans.isEmpty());
        assert (((Bean)tarantulaBeans.iterator().next()).getDeploymentType().equals(AnotherDeploymentType.class));
    }

    @Test(groups={"broken", "producerField", "enterpriseBeans"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.5"})
    public void testProducerFieldIsNotBusinessField() throws Exception {
        this.deployBeans(VibratingSpiderImpl_Broken.class);
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"3.5"})
    public void testParameterizedReturnType() throws Exception {
        this.deployBeans(FunnelWeaverSpiderProducer.class, FunnelWeaverSpiderConsumer.class);
        new AbstractTest.RunInDependentContext(){

            public void execute() {
                FunnelWeaverSpiderConsumer spiderConsumer = (FunnelWeaverSpiderConsumer)ProducerFieldDefinitionTest.this.manager.getInstanceByType(FunnelWeaverSpiderConsumer.class, new Annotation[0]);
                assert (spiderConsumer != null);
                assert (spiderConsumer.getInjectedSpider() != null);
                assert (spiderConsumer.getInjectedSpider().equals(FunnelWeaverSpiderProducer.getSpider()));
            }
        }.run();
    }

    @Test(groups={"producerField"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.5"})
    public void testParameterizedReturnTypeWithWildcard() {
        this.deployBeans(SpiderProducerWildCardType_Broken.class);
    }

    @Test(groups={"producerField", "deployment"})
    @SpecAssertion(section={"3.5"})
    public void testBeanDeclaresMultipleProducerFields() {
        this.deployBeans(OtherSpiderProducer.class);
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"3.5", "2.3.1"})
    public void testDefaultBindingType() {
        this.deployBeans(StaticTarantulaProducer.class);
        Set tarantulaBeans = this.manager.resolveByType(Tarantula.class, new Annotation[0]);
        assert (!tarantulaBeans.isEmpty());
        assert (((Bean)tarantulaBeans.iterator().next()).getBindings().contains((Object)new CurrentBinding()));
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"3.5.1"})
    public void testApiTypeForClassReturn() {
        this.deployBeans(StaticTarantulaProducer.class);
        Set tarantulaBeans = this.manager.resolveByType(Tarantula.class, new Annotation[0]);
        assert (!tarantulaBeans.isEmpty());
        Bean tarantulaModel = (Bean)tarantulaBeans.iterator().next();
        assert (tarantulaModel.getTypes().size() == 6);
        assert (tarantulaModel.getTypes().contains(Tarantula.class));
        assert (tarantulaModel.getTypes().contains(DeadlySpider.class));
        assert (tarantulaModel.getTypes().contains(Spider.class));
        assert (tarantulaModel.getTypes().contains(Animal.class));
        assert (tarantulaModel.getTypes().contains(DeadlyAnimal.class));
        assert (tarantulaModel.getTypes().contains(Object.class));
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"3.5.1"})
    public void testApiTypeForInterfaceReturn() {
        this.deployBeans(SpiderAsAnimalProducer.class);
        Set animalBeans = this.manager.resolveByType(Animal.class, new Annotation[0]);
        assert (!animalBeans.isEmpty());
        Bean animalModel = (Bean)animalBeans.iterator().next();
        assert (animalModel.getTypes().size() == 2);
        assert (animalModel.getTypes().contains(Animal.class));
        assert (animalModel.getTypes().contains(Object.class));
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"3.5.1"})
    public void testApiTypeForPrimitiveReturn() {
        this.deployBeans(OtherSpiderProducer.class);
        Set beans = this.manager.resolveByName("SpiderSize");
        assert (!beans.isEmpty());
        Bean intModel = (Bean)beans.iterator().next();
        assert (intModel.getTypes().size() == 2);
        assert (intModel.getTypes().contains(Integer.TYPE));
        assert (intModel.getTypes().contains(Object.class));
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"3.5.1", "2.2"})
    public void testApiTypeForArrayTypeReturn() {
        this.deployBeans(OtherSpiderProducer.class);
        Set spidersModels = this.manager.resolveByType(Spider[].class, new Annotation[0]);
        assert (!spidersModels.isEmpty());
        Bean spidersModel = (Bean)spidersModels.iterator().next();
        assert (spidersModel.getTypes().size() == 2);
        assert (spidersModel.getTypes().contains(Spider[].class));
        assert (spidersModel.getTypes().contains(Object.class));
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"3.5.2"})
    public void testBindingType() {
        this.deployBeans(TameTarantulaProducer.class);
        Set tarantulaBeans = this.manager.resolveByType(Tarantula.class, new Annotation[]{new TameAnnotationLiteral()});
        assert (!tarantulaBeans.isEmpty());
        Bean tarantulaModel = (Bean)tarantulaBeans.iterator().next();
        assert (tarantulaModel.getBindings().size() == 1);
        assert (((Annotation)tarantulaModel.getBindings().iterator().next()).annotationType().equals(Tame.class));
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"3.5.2"})
    public void testScopeType() {
        this.deployBeans(TameTarantulaProducer.class);
        Set tarantulaBeans = this.manager.resolveByType(Tarantula.class, new Annotation[]{new TameAnnotationLiteral()});
        assert (!tarantulaBeans.isEmpty());
        Bean tarantulaModel = (Bean)tarantulaBeans.iterator().next();
        assert (tarantulaModel.getScopeType().equals(RequestScoped.class));
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"3.5.2"})
    public void testDeploymentType() {
        this.deployBeans(TameTarantulaProducer.class);
        Set tarantulaBeans = this.manager.resolveByType(Tarantula.class, new Annotation[]{new TameAnnotationLiteral()});
        assert (!tarantulaBeans.isEmpty());
        Bean tarantulaModel = (Bean)tarantulaBeans.iterator().next();
        assert (tarantulaModel.getDeploymentType().equals(Production.class));
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"3.5.2"})
    public void testNamedField() {
        this.deployBeans(BlackWidowProducer.class);
        Set beans = this.manager.resolveByName("blackWidow");
        assert (!beans.isEmpty());
        Bean blackWidowModel = (Bean)beans.iterator().next();
        assert (blackWidowModel.getName().equals("blackWidow"));
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"2.6.3", "3.5.4"})
    public void testDefaultNamedField() {
        this.deployBeans(StaticTarantulaProducer.class);
        Set tarantulaBeans = this.manager.resolveByType(Tarantula.class, new Annotation[0]);
        assert (!tarantulaBeans.isEmpty());
        Bean tarantulaModel = (Bean)tarantulaBeans.iterator().next();
        assert (tarantulaModel.getName().equals("produceTarantula"));
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"2.7.2", "3.5.2", "2.2"})
    public void testStereotype() {
        this.deployBeans(StaticTarantulaProducer.class);
        Set tarantulaBeans = this.manager.resolveByType(Tarantula.class, new Annotation[0]);
        assert (!tarantulaBeans.isEmpty());
        Bean tarantulaModel = (Bean)tarantulaBeans.iterator().next();
        assert (tarantulaModel.getScopeType().equals(RequestScoped.class));
        assert (tarantulaModel.getDeploymentType().equals(Production.class));
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"4.2"})
    public void testNonStaticProducerFieldNotInherited() {
        this.deployBeans(InfertileChicken.class);
        assert (this.manager.resolveByType(Egg.class, new Annotation[0]).size() == 0);
    }
}

