/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.implementation.producer.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.context.RequestScoped;
import javax.inject.Current;
import javax.inject.DefinitionException;
import javax.inject.Production;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.unit.implementation.producer.method.Animal;
import org.jboss.webbeans.tck.unit.implementation.producer.method.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.implementation.producer.method.BeanWithStaticProducerMethod;
import org.jboss.webbeans.tck.unit.implementation.producer.method.DeadlyAnimal;
import org.jboss.webbeans.tck.unit.implementation.producer.method.DeadlySpider;
import org.jboss.webbeans.tck.unit.implementation.producer.method.Egg;
import org.jboss.webbeans.tck.unit.implementation.producer.method.InfertileChicken;
import org.jboss.webbeans.tck.unit.implementation.producer.method.Spider;
import org.jboss.webbeans.tck.unit.implementation.producer.method.SpiderProducer;
import org.jboss.webbeans.tck.unit.implementation.producer.method.SpiderProducer_Broken;
import org.jboss.webbeans.tck.unit.implementation.producer.method.Tame;
import org.jboss.webbeans.tck.unit.implementation.producer.method.Tarantula;
import org.testng.annotations.Test;

public class ProducerMethodDefinitionTest
extends AbstractTest {
    @Test(groups={"producerMethod"})
    @SpecAssertion(section={"2.5.3"})
    public void testProducerMethodInheritsDeploymentTypeOfDeclaringWebBean() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("produceTameTarantula", new Class[0]);
        Bean tarantulaModel = this.createProducerMethodBean(method, bean);
        tarantulaModel.getDeploymentType().equals(AnotherDeploymentType.class);
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section={"3.4"})
    public void testStaticMethod() throws Exception {
        Bean<BeanWithStaticProducerMethod> bean = this.createSimpleBean(BeanWithStaticProducerMethod.class);
        this.manager.addBean(bean);
        Method method = BeanWithStaticProducerMethod.class.getMethod("getString", new Class[0]);
        this.createProducerMethodBean(method, bean);
    }

    @Test(groups={"stub", "producerMethod", "enterpriseBeans", "stub"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.4"})
    public void testProducerMethodIsNotBusinessMethod() throws Exception {
        assert (false);
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section={"3.4"})
    public void testParameterizedReturnType() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("getFunnelWeaverSpider", new Class[0]);
        this.createProducerMethodBean(method, bean);
    }

    @Test(groups={"producerMethod"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.4"})
    public void testParameterizedReturnTypeWithWildcard() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("getAnotherFunnelWeaver", new Class[0]);
        this.createProducerMethodBean(method, bean);
    }

    @Test(groups={"producerMethod"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.4"})
    public void testParameterizedReturnTypeWithTypeParameter() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("getFunnelWeaver", new Class[0]);
        this.createProducerMethodBean(method, bean);
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section={"3.4", "2.3.1"})
    public void testDefaultBindingType() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("produceTarantula", new Class[0]);
        Bean tarantulaModel = this.createProducerMethodBean(method, bean);
        assert (tarantulaModel.getBindings().size() == 1);
        assert (((Annotation)tarantulaModel.getBindings().iterator().next()).annotationType().equals(Current.class));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section={"3.4.1"})
    public void testApiTypeForClassReturn() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("produceTarantula", new Class[0]);
        Bean tarantulaModel = this.createProducerMethodBean(method, bean);
        assert (tarantulaModel.getTypes().size() == 6);
        assert (tarantulaModel.getTypes().contains(Tarantula.class));
        assert (tarantulaModel.getTypes().contains(DeadlySpider.class));
        assert (tarantulaModel.getTypes().contains(Spider.class));
        assert (tarantulaModel.getTypes().contains(Animal.class));
        assert (tarantulaModel.getTypes().contains(DeadlyAnimal.class));
        assert (tarantulaModel.getTypes().contains(Object.class));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section={"3.4.1"})
    public void testApiTypeForInterfaceReturn() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("makeASpider", new Class[0]);
        Bean animalModel = this.createProducerMethodBean(method, bean);
        assert (animalModel.getTypes().size() == 2);
        assert (animalModel.getTypes().contains(Animal.class));
        assert (animalModel.getTypes().contains(Object.class));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section={"3.4.1"})
    public void testApiTypeForPrimitiveReturn() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("getWolfSpiderSize", new Class[0]);
        Bean intModel = this.createProducerMethodBean(method, bean);
        assert (intModel.getTypes().size() == 2);
        assert (intModel.getTypes().contains(Integer.TYPE));
        assert (intModel.getTypes().contains(Object.class));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section={"3.4.1", "2.2"})
    public void testApiTypeForArrayTypeReturn() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("getSpiders", new Class[0]);
        Bean spidersModel = this.createProducerMethodBean(method, bean);
        assert (spidersModel.getTypes().size() == 2);
        assert (spidersModel.getTypes().contains(Spider[].class));
        assert (spidersModel.getTypes().contains(Object.class));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section={"3.4.2"})
    public void testBindingType() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("produceTameTarantula", new Class[0]);
        Bean tarantulaModel = this.createProducerMethodBean(method, bean);
        assert (tarantulaModel.getBindings().size() == 1);
        assert (((Annotation)tarantulaModel.getBindings().iterator().next()).annotationType().equals(Tame.class));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section={"3.4.2"})
    public void testScopeType() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("produceDaddyLongLegs", new Class[0]);
        Bean daddyLongLegsModel = this.createProducerMethodBean(method, bean);
        assert (daddyLongLegsModel.getScopeType().equals(RequestScoped.class));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section={"3.4.2"})
    public void testDeploymentType() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("getLadybirdSpider", new Class[0]);
        Bean ladybirdSpiderModel = this.createProducerMethodBean(method, bean);
        assert (ladybirdSpiderModel.getDeploymentType().equals(Production.class));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section={"3.4.2"})
    public void testNamedMethod() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("produceBlackWidow", new Class[0]);
        Bean blackWidowSpiderModel = this.createProducerMethodBean(method, bean);
        assert (blackWidowSpiderModel.getName().equals("blackWidow"));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section={"3.4.2"})
    public void testDefaultNamedMethod() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("produceDaddyLongLegs", new Class[0]);
        Bean daddyLongLegsSpiderModel = this.createProducerMethodBean(method, bean);
        assert (daddyLongLegsSpiderModel.getName().equals("produceDaddyLongLegs"));
    }

    @Test(groups={"producerMethod"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.4"})
    public void testProducerMethodWithParameterAnnotatedDisposes() throws Exception {
        Bean<SpiderProducer_Broken> bean = this.createSimpleBean(SpiderProducer_Broken.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer_Broken.class.getMethod("dispose", String.class);
        this.createProducerMethodBean(method, bean);
    }

    @Test(groups={"producerMethod"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.4"})
    public void testProducerMethodWithParameterAnnotatedObserves() throws Exception {
        Bean<SpiderProducer_Broken> bean = this.createSimpleBean(SpiderProducer_Broken.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer_Broken.class.getMethod("observe", String.class);
        this.createProducerMethodBean(method, bean);
    }

    @Test(groups={"stub", "disposalMethod"})
    @SpecAssertion(section={"3.3.5"})
    public void testDisposalMethodNonStatic() {
        assert (false);
    }

    @Test(groups={"stub", "disposalMethod"})
    @SpecAssertion(section={"3.3.5"})
    public void testDisposalMethodMethodDeclaredOnWebBeanImplementationClass() {
        assert (false);
    }

    @Test(groups={"stub", "disposalMethod"})
    @SpecAssertion(section={"3.3.5"})
    public void testDisposalMethodBindingAnnotations() {
        assert (false);
    }

    @Test(groups={"stub", "disposalMethod"})
    @SpecAssertion(section={"3.3.5"})
    public void testDisposalMethodDefaultBindingAnnotations() {
        assert (false);
    }

    @Test(groups={"stub", "disposalMethod"})
    @SpecAssertion(section={"3.3.5"})
    public void testDisposalMethodDoesNotResolveToProducerMethod() {
        assert (false);
    }

    @Test(groups={"stub", "disposalMethod"})
    @SpecAssertion(section={"3.4.6"})
    public void testDisposalMethodDeclaredOnEnabledBean() {
        assert (false);
    }

    @Test(groups={"stub", "disposalMethod"})
    @SpecAssertion(section={"3.4.6"})
    public void testBeanCanDeclareMultipleDisposalMethods() {
        assert (false);
    }

    @Test(groups={"stub", "disposalMethod"})
    @SpecAssertion(section={"3.4.6"})
    public void testProducerMethodHasNoMoreThanOneDisposalMethod() {
        assert (false);
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section={"2.7.2", "3.4.2", "2.2"})
    public void testStereotypeSpecifiesScope() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("produceWolfSpider", new Class[0]);
        Bean wolfSpider = this.createProducerMethodBean(method, bean);
        assert (wolfSpider.getScopeType().equals(RequestScoped.class));
    }

    @Test(groups={"producerMethod"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.7.2", "3.4.2", "2.2"})
    public void testStereotypeEnforcesTypes() throws Exception {
        Bean<SpiderProducer_Broken> bean = this.createSimpleBean(SpiderProducer_Broken.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer_Broken.class.getMethod("produceInteger", new Class[0]);
        this.createProducerMethodBean(method, bean);
    }

    @Test
    @SpecAssertion(section={"4.2"})
    public void testNonStaticProducerMethodNotInherited() {
        this.deployBeans(InfertileChicken.class);
        assert (this.manager.resolveByType(Egg.class, new Annotation[0]).size() == 0);
    }
}

