/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.implementation.producer.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.inject.CreationException;
import javax.inject.IllegalProductException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.util.MockCreationalContext;
import org.jboss.webbeans.tck.unit.implementation.producer.method.FooException;
import org.jboss.webbeans.tck.unit.implementation.producer.method.Lorry;
import org.jboss.webbeans.tck.unit.implementation.producer.method.LorryProducer_Broken;
import org.jboss.webbeans.tck.unit.implementation.producer.method.Ship;
import org.jboss.webbeans.tck.unit.implementation.producer.method.ShipProducer_Broken;
import org.jboss.webbeans.tck.unit.implementation.producer.method.Spider;
import org.jboss.webbeans.tck.unit.implementation.producer.method.SpiderProducer;
import org.jboss.webbeans.tck.unit.implementation.producer.method.SpiderProducer_Broken;
import org.jboss.webbeans.tck.unit.implementation.producer.method.Tarantula;
import org.testng.annotations.Test;

public class ProducerMethodLifecycleTest
extends AbstractTest {
    @Test(groups={"producerMethod", "broken"})
    @SpecAssertion(section={"B.1"})
    public void testProducerMethodBeanCreate() throws Exception {
        Bean<SpiderProducer> spiderProducer = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(spiderProducer);
        Method method = SpiderProducer.class.getMethod("produceTarantula", new Class[0]);
        Bean tarantulaBean = this.createProducerMethodBean(method, spiderProducer);
        Tarantula tarantula = (Tarantula)tarantulaBean.create(new MockCreationalContext());
        assert (tarantula != null);
    }

    @Test(groups={"stub", "specialization"})
    @SpecAssertion(section={"3.3.4"})
    public void testSpecializedBeanAlwaysUsed() {
        assert (false);
    }

    @Test(groups={"stub", "disposalMethod", "beanLifecycle"})
    @SpecAssertion(section={"3.3.5"})
    public void testDisposalMethodCalled() {
        assert (false);
    }

    @Test(groups={"stub", "disposalMethod", "beanLifecycle"})
    @SpecAssertion(section={"3.3.5"})
    public void testDisposalMethodHasParametersInjected() {
        assert (false);
    }

    @Test(groups={"producerMethod", "broken"})
    @SpecAssertion(section={"3.4", "B.1", "7.3"})
    public void testProducerMethodReturnsNullIsDependent() throws Exception {
        Bean<SpiderProducer> spiderProducer = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(spiderProducer);
        Method method = SpiderProducer.class.getMethod("getNullSpider", new Class[0]);
        Bean spiderBean = this.createProducerMethodBean(method, spiderProducer);
        Spider spider = (Spider)spiderBean.create(new MockCreationalContext());
        assert (spider == null);
    }

    @Test(groups={"producerMethod"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section={"3.4", "B.1"})
    public void testProducerMethodReturnsNullIsNotDependent() throws Exception {
        Bean<SpiderProducer_Broken> spiderProducer = this.createSimpleBean(SpiderProducer_Broken.class);
        this.manager.addBean(spiderProducer);
        Method method = SpiderProducer_Broken.class.getMethod("getRequestScopedSpider", new Class[0]);
        this.createProducerMethodBean(method, spiderProducer).create(new MockCreationalContext());
    }

    @Test(expectedExceptions={CreationException.class})
    public void testCreationExceptionWrapsCheckedExceptionThrownFromCreate() throws Exception {
        this.deployBeans(LorryProducer_Broken.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                ProducerMethodLifecycleTest.this.manager.getInstanceByType(Lorry.class, new Annotation[0]);
            }
        }.run();
    }

    @Test(expectedExceptions={FooException.class})
    public void testUncheckedExceptionThrownFromCreateNotWrapped() throws Exception {
        this.deployBeans(ShipProducer_Broken.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                ProducerMethodLifecycleTest.this.manager.getInstanceByType(Ship.class, new Annotation[0]);
            }
        }.run();
    }
}

