/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.implementation.simple;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.context.Dependent;
import javax.inject.AnnotationLiteral;
import javax.inject.Current;
import javax.inject.DefinitionException;
import javax.inject.New;
import javax.inject.Standard;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.literals.NewLiteral;
import org.jboss.webbeans.tck.unit.implementation.simple.AnnotatedConstructorParameter;
import org.jboss.webbeans.tck.unit.implementation.simple.AnnotatedField;
import org.jboss.webbeans.tck.unit.implementation.simple.AnnotatedInitializerParameter;
import org.jboss.webbeans.tck.unit.implementation.simple.AnnotatedProducerParameter;
import org.jboss.webbeans.tck.unit.implementation.simple.Lion;
import org.jboss.webbeans.tck.unit.implementation.simple.NewAndOtherBindingType_Broken;
import org.jboss.webbeans.tck.unit.implementation.simple.Order;
import org.jboss.webbeans.tck.unit.implementation.simple.Tame;
import org.jboss.webbeans.tck.unit.implementation.simple.WrappedSimpleBean;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class NewSimpleBeanTest
extends AbstractTest {
    private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>(){};
    private Bean<WrappedSimpleBean> newSimpleBean;

    @BeforeMethod
    public void initNewBean() {
        this.deployBeans(WrappedSimpleBean.class);
        Set beans = this.manager.resolveByType(WrappedSimpleBean.class, new Annotation[]{new NewLiteral()});
        assert (beans.size() == 1);
        this.newSimpleBean = (Bean)beans.iterator().next();
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.2.5"})
    public void testNewBeanIsDependentScoped() {
        assert (Dependent.class.equals((Object)this.newSimpleBean.getScopeType()));
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.2.5"})
    public void testNewBeanIsOfStandardDeploymentType() {
        assert (Standard.class.equals((Object)this.newSimpleBean.getDeploymentType()));
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.2.5"})
    public void testNewBeanIsHasOnlyNewBinding() {
        assert (this.newSimpleBean.getBindings().size() == 1);
        assert (((Annotation)this.newSimpleBean.getBindings().iterator().next()).annotationType().equals(new NewLiteral().annotationType()));
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.2.5"})
    public void testNewBeanHasNoWebBeanName() {
        assert (this.newSimpleBean.getName() == null);
    }

    @Test(groups={"stub", "new"})
    @SpecAssertion(section={"3.2.5"})
    public void testNewBeanHasNoStereotypes() {
        assert (false);
    }

    @Test(groups={"new", "stub"})
    @SpecAssertion(section={"3.2.5"})
    public void testNewBeanHasNoObservers() {
        assert (false);
    }

    @Test(groups={"new", "stub"})
    @SpecAssertion(section={"3.2.5"})
    public void testNewBeanHasNoProducerFields() {
        assert (false);
    }

    @Test(groups={"new", "stub"})
    @SpecAssertion(section={"3.2.5"})
    public void testNewBeanHasNoProducerMethods() {
        assert (false);
    }

    @Test(groups={"new", "stub"})
    @SpecAssertion(section={"3.2.5"})
    public void testNewBeanHasNoDisposalMethods() {
        assert (false);
    }

    @Test(groups={"stub", "new"})
    @SpecAssertion(section={"3.2.5"})
    public void testNewBeanHasSameInterceptorMethodsAsWrappedBean() {
        assert (false);
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.2.5"})
    public void testNewBeanHasNoDecorators() {
        Annotation[] bindingTypes = this.newSimpleBean.getBindings().toArray(new Annotation[0]);
        assert (this.manager.resolveDecorators(this.newSimpleBean.getTypes(), bindingTypes).isEmpty());
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.2.5"})
    public void testNewAnnotationMayBeAppliedToField() {
        this.deployBeans(AnnotatedField.class, WrappedSimpleBean.class);
        assert (this.manager.resolveByType(WrappedSimpleBean.class, new Annotation[]{new NewLiteral()}).size() == 1);
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.2.5"})
    public void testNewAnnotationMayBeAppliedToProducerMethodParameter() {
        this.deployBeans(AnnotatedProducerParameter.class, WrappedSimpleBean.class);
        assert (this.manager.resolveByType(WrappedSimpleBean.class, new Annotation[]{new NewLiteral()}).size() == 1);
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.2.5"})
    public void testNewAnnotationMayBeAppliedToInitializerMethodParameter() {
        this.deployBeans(AnnotatedInitializerParameter.class, WrappedSimpleBean.class);
        assert (this.manager.resolveByType(WrappedSimpleBean.class, new Annotation[]{new NewLiteral()}).size() == 1);
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.2.5"})
    public void testNewAnnotationMayBeAppliedToConstructorMethodParameter() {
        this.deployBeans(AnnotatedConstructorParameter.class, WrappedSimpleBean.class);
        assert (this.manager.resolveByType(WrappedSimpleBean.class, new Annotation[]{new NewLiteral()}).size() == 1);
    }

    @Test(groups={"new"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.2.5"})
    public void testNewAnnotationCannotAppearInConjunctionWithOtherBindingType() {
        this.deployBeans(NewAndOtherBindingType_Broken.class);
    }

    @Test(groups={"stub", "new"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.2.5"})
    public void testNewAnnotationCannotBeAppliedToNonWebBeanImplementationClass() {
        assert (false);
    }

    @Test(groups={"stub", "new"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.2.5"})
    public void testNewAnnotationCannotBeExplicitlyDeclared() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"3.2.5"})
    public void testForEachSimpleBeanANewBeanExists() {
        this.deployBeans(Order.class, Lion.class);
        assert (this.manager.resolveByType(Order.class, new Annotation[0]).size() == 1);
        assert (((Bean)this.manager.resolveByType(Order.class, new Annotation[0]).iterator().next()).getBindings().size() == 1);
        assert (((Annotation)((Bean)this.manager.resolveByType(Order.class, new Annotation[0]).iterator().next()).getBindings().iterator().next()).annotationType().equals(Current.class));
        assert (this.manager.resolveByType(Order.class, new Annotation[]{new NewLiteral()}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Order.class, new Annotation[]{new NewLiteral()}).iterator().next()).getBindings().size() == 1);
        assert (((Annotation)((Bean)this.manager.resolveByType(Order.class, new Annotation[]{new NewLiteral()}).iterator().next()).getBindings().iterator().next()).annotationType().equals(New.class));
        assert (this.manager.resolveByType(Lion.class, new Annotation[]{TAME_LITERAL}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Lion.class, new Annotation[]{TAME_LITERAL}).iterator().next()).getBindings().size() == 1);
        assert (((Annotation)((Bean)this.manager.resolveByType(Lion.class, new Annotation[]{TAME_LITERAL}).iterator().next()).getBindings().iterator().next()).annotationType().equals(Tame.class));
        assert (this.manager.resolveByType(Lion.class, new Annotation[]{new NewLiteral()}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Lion.class, new Annotation[]{new NewLiteral()}).iterator().next()).getBindings().size() == 1);
        assert (((Annotation)((Bean)this.manager.resolveByType(Lion.class, new Annotation[]{new NewLiteral()}).iterator().next()).getBindings().iterator().next()).annotationType().equals(New.class));
    }
}

