/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.implementation.simple;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.CreationException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.util.MockCreationalContext;
import org.jboss.webbeans.tck.unit.implementation.simple.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.implementation.simple.CdOrderProcessor;
import org.jboss.webbeans.tck.unit.implementation.simple.Farm;
import org.jboss.webbeans.tck.unit.implementation.simple.FarmOffice;
import org.jboss.webbeans.tck.unit.implementation.simple.FishPond;
import org.jboss.webbeans.tck.unit.implementation.simple.FooException;
import org.jboss.webbeans.tck.unit.implementation.simple.Goldfish;
import org.jboss.webbeans.tck.unit.implementation.simple.Lorry_Broken;
import org.jboss.webbeans.tck.unit.implementation.simple.NovelOrderProcessor;
import org.jboss.webbeans.tck.unit.implementation.simple.OrderProcessor;
import org.jboss.webbeans.tck.unit.implementation.simple.RedSnapper;
import org.jboss.webbeans.tck.unit.implementation.simple.Tuna;
import org.jboss.webbeans.tck.unit.implementation.simple.TunaFarm;
import org.jboss.webbeans.tck.unit.implementation.simple.Van_Broken;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBeanLifecycleTest
extends AbstractTest {
    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
        deploymentTypes.add(AnotherDeploymentType.class);
        return deploymentTypes;
    }

    @Test(groups={"beanConstruction"})
    @SpecAssertion(section={"3.2.5.3"})
    public void testInjectionOfParametersIntoBeanConstructor() {
        Bean<FishPond> goldfishPondBean = this.createSimpleBean(FishPond.class);
        Bean<Goldfish> goldfishBean = this.createSimpleBean(Goldfish.class);
        this.manager.addBean(goldfishBean);
        this.manager.addBean(goldfishPondBean);
        FishPond fishPond = (FishPond)goldfishPondBean.create(new MockCreationalContext());
        assert (fishPond.goldfish != null);
    }

    @Test(groups={"stub", "specialization"})
    @SpecAssertion(section={"3.2.6"})
    public void testSpecializedBeanAlwaysUsed() {
        assert (false);
    }

    @Test(groups={"beanLifecycle"})
    @SpecAssertion(section={"5.3"})
    public void testCreateReturnsInstanceOfBean() {
        Bean<RedSnapper> bean = this.createSimpleBean(RedSnapper.class);
        assert (bean.create(new MockCreationalContext()) instanceof RedSnapper);
    }

    @Test(groups={"stub", "beanLifecycle", "interceptors"})
    @SpecAssertion(section={"6.3"})
    public void testCreateBindsInterceptorStack() {
        assert (false);
    }

    @Test(groups={"stub", "beanLifecycle", "decorators"})
    @SpecAssertion(section={"6.3"})
    public void testCreateBindsDecoratorStack() {
        assert (false);
    }

    @Test(groups={"stub", "beanLifecycle", "commonAnnotations"})
    @SpecAssertion(section={"6.3"})
    public void testCreateInjectsEjb() {
        assert (false);
    }

    @Test(groups={"stub", "beanLifecycle", "commonAnnotations"})
    @SpecAssertion(section={"6.3"})
    public void testCreateInjectsPersistenceContext() {
        assert (false);
    }

    @Test(groups={"stub", "beanLifecycle", "commonAnnotations"})
    @SpecAssertion(section={"6.3"})
    public void testCreateInjectsResource() {
        assert (false);
    }

    @Test(groups={"beanLifecycle", "lifecycleCallbacks"})
    @SpecAssertion(section={"6.3"})
    public void testPostConstructPreDestroy() throws Exception {
        Bean<FarmOffice> farmOfficeBean = this.createSimpleBean(FarmOffice.class);
        Bean<Farm> farmBean = this.createSimpleBean(Farm.class);
        this.manager.addBean(farmOfficeBean);
        this.manager.addBean(farmBean);
        Farm farm = (Farm)farmBean.create(new MockCreationalContext());
        assert (farm.founded != null);
        assert (farm.initialStaff == 20);
        assert (farm.closed == null);
        farmBean.destroy((Object)farm);
        assert (farm.closed != null);
    }

    @Test
    @SpecAssertion(section={"4.2"})
    public void testSubClassInheritsPostConstructOnSuperclass() throws Exception {
        OrderProcessor.postConstructCalled = false;
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                Bean<CdOrderProcessor> bean = SimpleBeanLifecycleTest.this.createSimpleBean(CdOrderProcessor.class);
                bean.create(new MockCreationalContext());
            }
        }.run();
        assert (OrderProcessor.postConstructCalled);
    }

    @Test
    @SpecAssertion(section={"4.2"})
    public void testSubClassInheritsPreDestroyOnSuperclass() throws Exception {
        OrderProcessor.preDestroyCalled = false;
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                Bean<CdOrderProcessor> bean = SimpleBeanLifecycleTest.this.createSimpleBean(CdOrderProcessor.class);
                CdOrderProcessor instance = (CdOrderProcessor)bean.create(new MockCreationalContext());
                bean.destroy((Object)instance);
            }
        }.run();
        assert (OrderProcessor.preDestroyCalled);
    }

    @Test
    @SpecAssertion(section={"4.2"})
    public void testSubClassDoesNotInheritPostConstructOnSuperclassBlockedByIntermediateClass() throws Exception {
        OrderProcessor.postConstructCalled = false;
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                Bean<NovelOrderProcessor> bean = SimpleBeanLifecycleTest.this.createSimpleBean(NovelOrderProcessor.class);
                bean.create(new MockCreationalContext());
            }
        }.run();
        assert (!OrderProcessor.postConstructCalled);
    }

    @Test
    @SpecAssertion(section={"4.2"})
    public void testSubClassDoesNotInheritPreDestroyConstructOnSuperclassBlockedByIntermediateClass() throws Exception {
        OrderProcessor.preDestroyCalled = false;
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                Bean<NovelOrderProcessor> bean = SimpleBeanLifecycleTest.this.createSimpleBean(NovelOrderProcessor.class);
                NovelOrderProcessor instance = (NovelOrderProcessor)bean.create(new MockCreationalContext());
                bean.destroy((Object)instance);
            }
        }.run();
        assert (!OrderProcessor.preDestroyCalled);
    }

    @Test(groups={"injection"})
    @SpecAssertion(section={"6.3"})
    public void testCreateInjectsFieldsDeclaredInJava() {
        Bean<TunaFarm> tunaFarmBean = this.createSimpleBean(TunaFarm.class);
        Bean<Tuna> tunaBean = this.createSimpleBean(Tuna.class);
        this.manager.addBean(tunaBean);
        TunaFarm tunaFarm = (TunaFarm)tunaFarmBean.create(new MockCreationalContext());
        assert (tunaFarm.tuna != null);
    }

    @Test(groups={"injection"})
    public void testFieldMissingBindingAnnotationsAreNotInjected() {
        Bean<TunaFarm> tunaFarmBean = this.createSimpleBean(TunaFarm.class);
        Bean<Tuna> tunaBean = this.createSimpleBean(Tuna.class);
        this.manager.addBean(tunaBean);
        TunaFarm tunaFarm = (TunaFarm)tunaFarmBean.create(new MockCreationalContext());
        assert (tunaFarm.notInjectedTuna != this.manager.getInstance(tunaBean));
    }

    @Test(expectedExceptions={CreationException.class})
    public void testCreationExceptionWrapsCheckedExceptionThrownFromCreate() throws Exception {
        this.deployBeans(Lorry_Broken.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                SimpleBeanLifecycleTest.this.manager.getInstanceByType(Lorry_Broken.class, new Annotation[0]);
            }
        }.run();
    }

    @Test(expectedExceptions={FooException.class})
    public void testUncheckedExceptionThrownFromCreateNotWrapped() throws Exception {
        this.deployBeans(Van_Broken.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                SimpleBeanLifecycleTest.this.manager.getInstanceByType(Van_Broken.class, new Annotation[0]);
            }
        }.run();
    }
}

