/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.lookup.typesafe;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.inject.AnnotationLiteral;
import javax.inject.DefinitionException;
import javax.inject.DuplicateBindingTypeException;
import javax.inject.TypeLiteral;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.literals.CurrentBinding;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Animal;
import org.jboss.webbeans.tck.unit.lookup.typesafe.AnimalFarmer;
import org.jboss.webbeans.tck.unit.lookup.typesafe.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.lookup.typesafe.AnotherDeploymentTypeLiteral;
import org.jboss.webbeans.tck.unit.lookup.typesafe.BindingTypeWithBindingAnnotationMemberLiteral_Broken;
import org.jboss.webbeans.tck.unit.lookup.typesafe.BindingTypeWithBindingArrayTypeMemberLiteral_Broken;
import org.jboss.webbeans.tck.unit.lookup.typesafe.ChunkyLiteral;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Cod;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Expensive;
import org.jboss.webbeans.tck.unit.lookup.typesafe.ExpensiveLiteral;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Farmer;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Haddock;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Halibut;
import org.jboss.webbeans.tck.unit.lookup.typesafe.ParameterizedBean_Broken;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Plaice;
import org.jboss.webbeans.tck.unit.lookup.typesafe.RoundWhitefish;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Salmon;
import org.jboss.webbeans.tck.unit.lookup.typesafe.ScottishFish;
import org.jboss.webbeans.tck.unit.lookup.typesafe.ScottishFishFarmer;
import org.jboss.webbeans.tck.unit.lookup.typesafe.SeaBass;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Sole;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Spider;
import org.jboss.webbeans.tck.unit.lookup.typesafe.SpiderProducer;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Tuna;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Whitefish;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolutionByTypeTest
extends AbstractTest {
    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
        deploymentTypes.add(AnotherDeploymentType.class);
        return deploymentTypes;
    }

    @Test(groups={"resolution"})
    @SpecAssertion(section={"5.9"})
    public void testDefaultBindingTypeAssumed() throws Exception {
        Bean<Tuna> tunaBean = this.createSimpleBean(Tuna.class);
        this.manager.addBean(tunaBean);
        Set possibleTargets = this.manager.resolveByType(Tuna.class, new Annotation[0]);
        assert (possibleTargets.size() == 1);
        assert (possibleTargets.contains(tunaBean));
    }

    @Test(groups={"resolution"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section={"5.9"})
    public void testParameterizedTypeWithWildcardParameter() {
        this.manager.resolveByType(new TypeLiteral<ParameterizedBean_Broken<?>>(){}, new Annotation[0]);
    }

    @Test(groups={"resolution"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section={"5.9"})
    public <T> void testParameterizedTypeWithTypeParameter() {
        this.manager.resolveByType(new TypeLiteral<ParameterizedBean_Broken<T>>(){}, new Annotation[0]);
    }

    @Test(groups={"resolution"}, expectedExceptions={DuplicateBindingTypeException.class})
    @SpecAssertion(section={"5.9"})
    public void testDuplicateBindingTypesUsed() {
        this.manager.resolveByType(Tuna.class, new Annotation[]{new CurrentBinding(), new CurrentBinding()});
    }

    @Test(groups={"resolution"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section={"5.9"})
    public void testNonBindingTypeUsed() {
        this.manager.resolveByType(Tuna.class, new Annotation[]{new AnotherDeploymentTypeLiteral()});
    }

    @Test(groups={"resolution"})
    @SpecAssertion(section={"5.9"})
    public void testResolveByType() throws Exception {
        Bean<Tuna> tunaBean = this.createSimpleBean(Tuna.class);
        Bean<Salmon> salmonBean = this.createSimpleBean(Salmon.class);
        Bean<SeaBass> seaBassBean = this.createSimpleBean(SeaBass.class);
        Bean<Haddock> haddockBean = this.createSimpleBean(Haddock.class);
        this.manager.addBean(tunaBean);
        this.manager.addBean(salmonBean);
        this.manager.addBean(haddockBean);
        this.manager.addBean(seaBassBean);
        assert (this.manager.resolveByType(Tuna.class, new Annotation[]{new CurrentBinding()}).size() == 1);
        assert (this.manager.resolveByType(Tuna.class, new Annotation[]{new CurrentBinding()}).contains(tunaBean));
        assert (this.manager.resolveByType(Tuna.class, new Annotation[0]).size() == 1);
        assert (this.manager.resolveByType(Tuna.class, new Annotation[0]).contains(tunaBean));
        assert (this.manager.resolveByType(Animal.class, new Annotation[]{new CurrentBinding()}).size() == 3);
        assert (this.manager.resolveByType(Animal.class, new Annotation[]{new CurrentBinding()}).contains(salmonBean));
        assert (this.manager.resolveByType(Animal.class, new Annotation[]{new CurrentBinding()}).contains(seaBassBean));
        assert (this.manager.resolveByType(Animal.class, new Annotation[]{new CurrentBinding()}).contains(haddockBean));
    }

    @Test(groups={"injection"})
    @SpecAssertion(section={"2.3.5", "5.9.2"})
    public void testAllBindingTypesSpecifiedForResolutionMustAppearOnWebBean() {
        Bean<Cod> codBean = this.createSimpleBean(Cod.class);
        Bean<Salmon> salmonBean = this.createSimpleBean(Salmon.class);
        Bean<Sole> soleBean = this.createSimpleBean(Sole.class);
        this.manager.addBean(codBean);
        this.manager.addBean(salmonBean);
        this.manager.addBean(soleBean);
        assert (this.manager.resolveByType(Animal.class, new Annotation[]{new ChunkyLiteral(){

            public boolean realChunky() {
                return true;
            }
        }, new AnnotationLiteral<Whitefish>(){}}).size() == 1);
        assert (this.manager.resolveByType(Animal.class, new Annotation[]{new ChunkyLiteral(){

            public boolean realChunky() {
                return true;
            }
        }, new AnnotationLiteral<Whitefish>(){}}).contains(codBean));
        assert (this.manager.resolveByType(ScottishFish.class, new Annotation[]{new AnnotationLiteral<Whitefish>(){}}).size() == 2);
        assert (this.manager.resolveByType(ScottishFish.class, new Annotation[]{new AnnotationLiteral<Whitefish>(){}}).contains(codBean));
        assert (this.manager.resolveByType(ScottishFish.class, new Annotation[]{new AnnotationLiteral<Whitefish>(){}}).contains(soleBean));
    }

    @Test(groups={"resolution"})
    @SpecAssertion(section={"5.9"})
    public void testResolveByTypeWithTypeParameter() throws Exception {
        Bean<ScottishFishFarmer> scottishFishFarmerBean = this.createSimpleBean(ScottishFishFarmer.class);
        Bean<AnimalFarmer> farmerBean = this.createSimpleBean(AnimalFarmer.class);
        this.manager.addBean(scottishFishFarmerBean);
        this.manager.addBean(farmerBean);
        assert (this.manager.resolveByType((TypeLiteral)new TypeLiteral<Farmer<ScottishFish>>(){}, new Annotation[0]).size() == 1);
        assert (this.manager.resolveByType((TypeLiteral)new TypeLiteral<Farmer<ScottishFish>>(){}, new Annotation[0]).contains(scottishFishFarmerBean));
    }

    @Test(groups={"resolution", "producerMethod"})
    @SpecAssertion(section={"5.9"})
    public void testResolveByTypeWithArray() throws Exception {
        Bean<SpiderProducer> spiderProducerBean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(spiderProducerBean);
        Method method = SpiderProducer.class.getMethod("getSpiders", new Class[0]);
        Bean spidersModel = this.createProducerMethodBean(method, spiderProducerBean);
        this.manager.addBean(spidersModel);
        method = SpiderProducer.class.getMethod("getStrings", new Class[0]);
        Bean stringModel = this.createProducerMethodBean(method, spiderProducerBean);
        this.manager.addBean(stringModel);
        assert (this.manager.resolveByType(Spider[].class, new Annotation[0]).size() == 1);
    }

    @Test
    @SpecAssertion(section={"5.9"})
    public void testOnlyHighestEnabledPrecedenceWebBeansResolved() throws Exception {
        Bean<Cod> codBean = this.createSimpleBean(Cod.class);
        Bean<Sole> soleBean = this.createSimpleBean(Sole.class);
        Bean<Plaice> plaiceBean = this.createSimpleBean(Plaice.class);
        this.manager.addBean(plaiceBean);
        this.manager.addBean(codBean);
        this.manager.addBean(soleBean);
        assert (this.manager.resolveByType(Animal.class, new Annotation[]{new AnnotationLiteral<Whitefish>(){}}).size() == 1);
        assert (this.manager.resolveByType(Animal.class, new Annotation[]{new AnnotationLiteral<Whitefish>(){}}).contains(plaiceBean));
    }

    @Test(groups={"resolution"})
    @SpecAssertion(section={"5.9"})
    public void testNoWebBeansFound() throws Exception {
        Bean<Salmon> salmonBean = this.createSimpleBean(Salmon.class);
        Bean<Sole> soleBean = this.createSimpleBean(Sole.class);
        Bean<Plaice> plaiceBean = this.createSimpleBean(Plaice.class);
        this.manager.addBean(plaiceBean);
        this.manager.addBean(salmonBean);
        this.manager.addBean(soleBean);
        assert (this.manager.resolveByType(Tuna.class, new Annotation[]{new CurrentBinding()}).size() == 0);
    }

    @Test(groups={"resolution"})
    @SpecAssertion(section={"5.9.1"})
    public void testResolveByTypeWithNonBindingMembers() throws Exception {
        Bean<Halibut> halibutBean = this.createSimpleBean(Halibut.class);
        Bean<RoundWhitefish> roundWhiteFishBean = this.createSimpleBean(RoundWhitefish.class);
        Bean<Sole> soleBean = this.createSimpleBean(Sole.class);
        this.manager.addBean(halibutBean);
        this.manager.addBean(roundWhiteFishBean);
        this.manager.addBean(soleBean);
        Set beans = this.manager.resolveByType(Animal.class, new Annotation[]{new ExpensiveLiteral(){

            public int cost() {
                return 60;
            }

            public boolean veryExpensive() {
                return true;
            }
        }, new AnnotationLiteral<Whitefish>(){}});
        assert (beans.size() == 2);
        assert (beans.contains(halibutBean));
        assert (beans.contains(roundWhiteFishBean));
    }

    @Test(groups={"resolution"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"5.9.1"})
    public void testArrayValuedAnnotationMemberWithoutNonBinding() {
        this.manager.resolveByType(Animal.class, new Annotation[]{new BindingTypeWithBindingArrayTypeMemberLiteral_Broken(){

            public boolean[] bool() {
                return new boolean[0];
            }
        }});
    }

    @Test(groups={"resolution"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"5.9.1"})
    public void testAnnotationValuedAnnotationMemberWithoutNonBinding() {
        this.manager.resolveByType(Animal.class, new Annotation[]{new BindingTypeWithBindingAnnotationMemberLiteral_Broken(){

            public Expensive expensive() {
                return new ExpensiveLiteral(){

                    public int cost() {
                        return 0;
                    }

                    public boolean veryExpensive() {
                        return false;
                    }
                };
            }
        }});
    }
}

