/*
 * Decompiled with CFR 0.152.
 */
package javax.webbeans;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.webbeans.ExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationLiteral<T extends Annotation>
implements Annotation {
    private Class<T> annotationType;
    private Method[] members;

    protected AnnotationLiteral() {
        Class<?> annotationLiteralSubclass = AnnotationLiteral.getAnnotationLiteralSubclass(this.getClass());
        if (annotationLiteralSubclass == null) {
            throw new RuntimeException(this.getClass() + "is not a subclass of AnnotationLiteral ");
        }
        this.annotationType = AnnotationLiteral.getTypeParameter(annotationLiteralSubclass);
        if (this.annotationType == null) {
            throw new RuntimeException(this.getClass() + " is missing type parameter in AnnotationLiteral");
        }
        this.members = this.annotationType.getDeclaredMethods();
    }

    private static Class<?> getAnnotationLiteralSubclass(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass.equals(AnnotationLiteral.class)) {
            return clazz;
        }
        if (superclass.equals(Object.class)) {
            return null;
        }
        return AnnotationLiteral.getAnnotationLiteralSubclass(superclass);
    }

    private static <T> Class<T> getTypeParameter(Class<?> annotationLiteralSuperclass) {
        ParameterizedType parameterizedType;
        Type type = annotationLiteralSuperclass.getGenericSuperclass();
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getActualTypeArguments().length == 1) {
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    @Override
    public String toString() {
        String string = "@" + this.annotationType().getName() + "(";
        for (int i = 0; i < this.members.length; ++i) {
            string = string + this.members[i].getName() + "=";
            string = string + AnnotationLiteral.invoke(this.members[i], this);
            if (i >= this.members.length - 1) continue;
            string = string + ",";
        }
        return string + ")";
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Annotation) {
            Annotation that = (Annotation)other;
            if (this.annotationType().equals(that.annotationType())) {
                for (Method member : this.members) {
                    Object thatValue;
                    Object thisValue = AnnotationLiteral.invoke(member, this);
                    if (thisValue.equals(thatValue = AnnotationLiteral.invoke(member, that))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Method member : this.members) {
            int memberNameHashCode = 127 * member.getName().hashCode();
            int memberValueHashCode = AnnotationLiteral.invoke(member, this).hashCode();
            hashCode += memberNameHashCode ^ memberValueHashCode;
        }
        return hashCode;
    }

    private static Object invoke(Method method, Object instance) {
        try {
            return method.invoke(instance, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new ExecutionException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
    }
}

