/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.webbeans.NullableDependencyException;
import javax.webbeans.manager.Bean;
import javax.webbeans.manager.Decorator;
import javax.webbeans.manager.InterceptionType;
import javax.webbeans.manager.Interceptor;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.MetaDataCache;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.introspector.ForwardingAnnotatedItem;
import org.jboss.webbeans.model.BindingTypeModel;
import org.jboss.webbeans.util.ConcurrentCache;
import org.jboss.webbeans.util.ListComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolver
implements Serializable {
    private ConcurrentCache<ResolvableAnnotatedItem<?, ?>, Set<Bean<?>>> resolvedInjectionPoints;
    private Set<AnnotatedItem<?, ?>> injectionPoints = new HashSet();
    private ConcurrentCache<String, Set<Bean<?>>> resolvedNames;
    private ManagerImpl manager;

    public Resolver(ManagerImpl manager) {
        this.resolvedInjectionPoints = new ConcurrentCache();
        this.resolvedNames = new ConcurrentCache();
        this.manager = manager;
    }

    public void addInjectionPoints(Collection<AnnotatedItem<?, ?>> elements) {
        this.injectionPoints.addAll(elements);
    }

    private <T, S> Set<Bean<T>> registerInjectionPoint(final ResolvableAnnotatedItem<T, S> element) {
        Callable callable = new Callable<Set<Bean<T>>>(){

            @Override
            public Set<Bean<T>> call() throws Exception {
                Set beans = Resolver.retainHighestPrecedenceBeans(Resolver.this.getMatchingBeans(element, Resolver.this.manager.getBeans()), Resolver.this.manager.getEnabledDeploymentTypes());
                if (element.getType().isPrimitive()) {
                    for (Bean bean : beans) {
                        if (!bean.isNullable()) continue;
                        throw new NullableDependencyException("Primitive injection points resolves to nullable web bean");
                    }
                }
                return beans;
            }
        };
        return (Set)this.resolvedInjectionPoints.putIfAbsent(element, callable);
    }

    public void clear() {
        this.resolvedInjectionPoints = new ConcurrentCache();
        this.resolvedNames = new ConcurrentCache();
    }

    public void resolveInjectionPoints() {
        for (final AnnotatedItem<?, ?> injectable : this.injectionPoints) {
            this.registerInjectionPoint(new ResolvableAnnotatedItem<Object, Object>(){

                @Override
                public AnnotatedItem<Object, Object> delegate() {
                    return injectable;
                }
            });
        }
    }

    public <T, S> Set<Bean<T>> get(final AnnotatedItem<T, S> key) {
        Set<Object> beans = new HashSet();
        ResolvableAnnotatedItem element = new ResolvableAnnotatedItem<T, S>(){

            @Override
            public AnnotatedItem<T, S> delegate() {
                return key;
            }
        };
        beans = element.getType().equals(Object.class) ? new HashSet(this.manager.getBeans()) : this.registerInjectionPoint(element);
        return Collections.unmodifiableSet(beans);
    }

    public Set<Bean<?>> get(final String name) {
        return (Set)this.resolvedNames.putIfAbsent(name, new Callable<Set<Bean<?>>>(){

            @Override
            public Set<Bean<?>> call() throws Exception {
                HashSet beans = new HashSet();
                for (Bean<?> bean : Resolver.this.manager.getBeans()) {
                    if ((bean.getName() != null || name != null) && (bean.getName() == null || !bean.getName().equals(name))) continue;
                    beans.add(bean);
                }
                return Resolver.retainHighestPrecedenceBeans(beans, Resolver.this.manager.getEnabledDeploymentTypes());
            }
        });
    }

    private static <T> Set<Bean<T>> retainHighestPrecedenceBeans(Set<Bean<T>> beans, List<Class<? extends Annotation>> enabledDeploymentTypes) {
        if (beans.size() > 0) {
            TreeSet<Class<? extends Annotation>> possibleDeploymentTypes = new TreeSet<Class<? extends Annotation>>(new ListComparator<Class<? extends Annotation>>(enabledDeploymentTypes));
            for (Bean<T> bean : beans) {
                possibleDeploymentTypes.add(bean.getDeploymentType());
            }
            possibleDeploymentTypes.retainAll(enabledDeploymentTypes);
            HashSet<Bean<T>> trimmed = new HashSet<Bean<T>>();
            if (possibleDeploymentTypes.size() > 0) {
                Class highestPrecedencePossibleDeploymentType = (Class)possibleDeploymentTypes.last();
                for (Bean<T> bean : beans) {
                    if (!bean.getDeploymentType().equals(highestPrecedencePossibleDeploymentType)) continue;
                    trimmed.add(bean);
                }
            }
            return trimmed;
        }
        return beans;
    }

    private <T> Set<Bean<T>> getMatchingBeans(AnnotatedItem<T, ?> element, List<Bean<?>> beans) {
        HashSet<Bean<T>> resolvedBeans = new HashSet<Bean<T>>();
        for (Bean<?> bean : beans) {
            if (!element.isAssignableFrom(bean.getTypes()) || !this.containsAllBindingBindingTypes(element, bean.getBindingTypes())) continue;
            resolvedBeans.add(bean);
        }
        return resolvedBeans;
    }

    private boolean containsAllBindingBindingTypes(AnnotatedItem<?, ?> element, Set<Annotation> bindingTypes) {
        for (Annotation bindingType : element.getBindingTypes()) {
            BindingTypeModel<? extends Annotation> bindingTypeModel = MetaDataCache.instance().getBindingTypeModel(bindingType.annotationType());
            if (bindingTypeModel.getNonBindingTypes().size() > 0) {
                boolean matchFound = false;
                for (Annotation otherBindingType : bindingTypes) {
                    if (!bindingTypeModel.isEqual(bindingType, otherBindingType)) continue;
                    matchFound = true;
                }
                if (matchFound) continue;
                return false;
            }
            if (bindingTypes.contains(bindingType)) continue;
            return false;
        }
        return true;
    }

    public List<Decorator> resolveDecorators(Set<Class<?>> types, Annotation[] bindingTypes) {
        return null;
    }

    public List<Interceptor> resolveInterceptors(InterceptionType type, Annotation[] interceptorBindings) {
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Resolver\n");
        buffer.append("Injection points: " + this.injectionPoints.size() + "\n");
        buffer.append("Resolved injection points: " + this.resolvedInjectionPoints.size() + "\n");
        buffer.append("Resolved names points: " + this.resolvedNames.size() + "\n");
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ResolvableAnnotatedItem<T, S>
    extends ForwardingAnnotatedItem<T, S>
    implements Serializable {
        private ResolvableAnnotatedItem() {
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof AnnotatedItem) {
                AnnotatedItem that = (AnnotatedItem)other;
                return this.delegate().isAssignableFrom(that) && ((Object)that.getBindingTypes()).equals(this.getBindingTypes());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.delegate().hashCode();
        }

        @Override
        public String toString() {
            return "Resolvable annotated item for " + this.delegate();
        }
    }
}

