/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.webbeans.BindingType;
import javax.webbeans.DefinitionException;
import javax.webbeans.Dependent;
import javax.webbeans.DeploymentType;
import javax.webbeans.Event;
import javax.webbeans.Named;
import javax.webbeans.ScopeType;
import javax.webbeans.Specializes;
import javax.webbeans.Standard;
import javax.webbeans.Stereotype;
import javax.webbeans.manager.Bean;
import javax.webbeans.manager.Manager;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bindings.CurrentBinding;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedItem;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.model.MergedStereotypes;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBean<T, E>
extends Bean<T> {
    private static Set<Class<?>> STANDARD_WEB_BEAN_CLASSES = new HashSet<Class>(Arrays.asList(Event.class, ManagerImpl.class));
    private LogProvider log = Logging.getLogProvider(AbstractBean.class);
    private Set<Annotation> bindingTypes;
    protected String name;
    protected Class<? extends Annotation> scopeType;
    private MergedStereotypes<T, E> mergedStereotypes;
    protected Class<? extends Annotation> deploymentType;
    protected Class<T> type;
    protected Set<Class<?>> apiTypes;
    protected Set<AnnotatedItem<?, ?>> injectionPoints;
    private boolean primitive;
    protected ManagerImpl manager;
    private Type declaredBeanType;

    public static Class<? extends Annotation> getDeploymentType(List<Class<? extends Annotation>> enabledDeploymentTypes, AbstractAnnotatedItem.AnnotationMap possibleDeploymentTypes) {
        for (int i = enabledDeploymentTypes.size() - 1; i > 0; --i) {
            if (!possibleDeploymentTypes.containsKey(enabledDeploymentTypes.get(i))) continue;
            return enabledDeploymentTypes.get(i);
        }
        return null;
    }

    public AbstractBean(ManagerImpl manager) {
        super((Manager)manager);
        this.manager = manager;
    }

    protected void init() {
        this.mergedStereotypes = new MergedStereotypes(this.getAnnotatedItem().getMetaAnnotations(Stereotype.class));
        this.initType();
        this.initPrimitive();
        this.log.debug("Building Web Bean bean metadata for " + this.getType());
        this.initBindingTypes();
        this.initName();
        this.initDeploymentType();
        this.checkDeploymentType();
        this.initScopeType();
        this.initApiTypes();
    }

    protected void initApiTypes() {
        this.apiTypes = Reflections.getTypeHierachy(this.getType());
    }

    protected void initBindingTypes() {
        this.bindingTypes = new HashSet<Annotation>();
        boolean specialization = this.getAnnotatedItem().isAnnotationPresent(Specializes.class);
        this.bindingTypes.addAll(this.getAnnotatedItem().getMetaAnnotations(BindingType.class));
        if (specialization) {
            this.bindingTypes.addAll(this.getSpecializedType().getBindingTypes());
            this.log.trace("Using binding types " + this.bindingTypes + " specified by annotations and specialized supertype");
        } else if (this.bindingTypes.size() == 0) {
            this.log.trace("Adding default @Current binding type");
            this.bindingTypes.add((Annotation)((Object)new CurrentBinding()));
        } else {
            this.log.trace("Using binding types " + this.bindingTypes + " specified by annotations");
        }
    }

    protected void initDeploymentType() {
        Set<Annotation> deploymentTypes = this.getAnnotatedItem().getMetaAnnotations(DeploymentType.class);
        if (deploymentTypes.size() > 1) {
            throw new DefinitionException("At most one deployment type may be specified (" + deploymentTypes + " are specified) on " + this.getAnnotatedItem().toString());
        }
        if (deploymentTypes.size() == 1) {
            this.deploymentType = deploymentTypes.iterator().next().annotationType();
            this.log.trace("Deployment type " + this.deploymentType + " specified by annotation");
            return;
        }
        AbstractAnnotatedItem.AnnotationMap possibleDeploymentTypes = this.getMergedStereotypes().getPossibleDeploymentTypes();
        if (possibleDeploymentTypes.size() > 0) {
            this.deploymentType = AbstractBean.getDeploymentType(this.manager.getEnabledDeploymentTypes(), possibleDeploymentTypes);
            this.log.trace("Deployment type " + this.deploymentType + " specified by stereotype");
            return;
        }
        this.deploymentType = this.getDefaultDeploymentType();
        this.log.trace("Using default @Production deployment type");
    }

    protected abstract Class<? extends Annotation> getDefaultDeploymentType();

    protected void initInjectionPoints() {
        this.injectionPoints = new HashSet();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initName() {
        boolean beanNameDefaulted = false;
        boolean specialization = this.getAnnotatedItem().isAnnotationPresent(Specializes.class);
        if (this.getAnnotatedItem().isAnnotationPresent(Named.class)) {
            if (specialization) {
                throw new DefinitionException("Name specified for specialized bean");
            }
            String javaName = this.getAnnotatedItem().getAnnotation(Named.class).value();
            if (!"".equals(javaName)) {
                this.log.trace("Using name " + javaName + " specified by annotations");
                this.name = javaName;
                return;
            }
            this.log.trace("Using default name (specified by annotations)");
            beanNameDefaulted = true;
        } else if (specialization) {
            this.name = this.getSpecializedType().getName();
            this.log.trace("Using supertype name");
            return;
        }
        if (!beanNameDefaulted && !this.getMergedStereotypes().isBeanNameDefaulted()) {
            return;
        }
        this.name = this.getDefaultName();
    }

    protected void initPrimitive() {
        this.primitive = Reflections.isPrimitive(this.getType());
    }

    protected void initScopeType() {
        Set<Annotation> scopeAnnotations = this.getAnnotatedItem().getMetaAnnotations(ScopeType.class);
        if (scopeAnnotations.size() > 1) {
            throw new DefinitionException("At most one scope may be specified");
        }
        if (scopeAnnotations.size() == 1) {
            this.scopeType = scopeAnnotations.iterator().next().annotationType();
            this.log.trace("Scope " + this.scopeType + " specified by annotation");
            return;
        }
        Set<Annotation> possibleScopeTypes = this.getMergedStereotypes().getPossibleScopeTypes();
        if (possibleScopeTypes.size() == 1) {
            this.scopeType = possibleScopeTypes.iterator().next().annotationType();
            this.log.trace("Scope " + this.scopeType + " specified by stereotype");
            return;
        }
        if (possibleScopeTypes.size() > 1) {
            throw new DefinitionException("All stereotypes must specify the same scope OR a scope must be specified on the bean");
        }
        this.scopeType = Dependent.class;
        this.log.trace("Using default @Dependent scope");
    }

    protected abstract void initType();

    protected void checkDeploymentType() {
        if (this.deploymentType == null) {
            throw new DefinitionException("type: " + this.getType() + " must specify a deployment type");
        }
        if (this.deploymentType.equals(Standard.class) && !STANDARD_WEB_BEAN_CLASSES.contains(this.getAnnotatedItem().getType())) {
            throw new DefinitionException(this.getAnnotatedItem().getName() + " cannot have deployment type @Standard");
        }
    }

    protected void bindDecorators() {
    }

    protected void bindInterceptors() {
    }

    protected abstract AnnotatedItem<T, E> getAnnotatedItem();

    public Set<Annotation> getBindingTypes() {
        return this.bindingTypes;
    }

    protected Type getDeclaredBeanType() {
        ParameterizedType parameterizedType;
        Class<?> type;
        if (this.declaredBeanType == null && (type = ((Object)((Object)this)).getClass()) instanceof ParameterizedType && (parameterizedType = (ParameterizedType)((Object)type)).getActualTypeArguments().length == 1) {
            this.declaredBeanType = parameterizedType.getActualTypeArguments()[0];
        }
        return this.declaredBeanType;
    }

    protected abstract String getDefaultName();

    public Class<? extends Annotation> getDeploymentType() {
        return this.deploymentType;
    }

    public Set<AnnotatedItem<?, ?>> getInjectionPoints() {
        return this.injectionPoints;
    }

    public MergedStereotypes<T, E> getMergedStereotypes() {
        return this.mergedStereotypes;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends Annotation> getScopeType() {
        return this.scopeType;
    }

    protected AbstractBean<? extends T, E> getSpecializedType() {
        throw new UnsupportedOperationException();
    }

    public Class<T> getType() {
        return this.type;
    }

    public Set<Class<?>> getTypes() {
        return this.apiTypes;
    }

    public boolean isAssignableFrom(AnnotatedItem<?, ?> annotatedItem) {
        return this.getAnnotatedItem().isAssignableFrom(annotatedItem);
    }

    public boolean isNullable() {
        return !this.isPrimitive();
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isSerializable() {
        return false;
    }

    public String toString() {
        return "AbstractBean " + this.getName();
    }

    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("AbstractBean:\n");
        buffer.append("Name: " + this.name + "\n");
        buffer.append("Type: " + this.type + "\n");
        buffer.append("Scope type " + this.scopeType.toString() + "\n");
        buffer.append("Deployment type: " + this.deploymentType.toString() + "\n");
        buffer.append("Primitive : " + this.primitive + "\n");
        buffer.append("Declared bean type: " + (this.declaredBeanType == null ? "null" : this.declaredBeanType.toString()) + "\n");
        buffer.append(Strings.collectionToString("Binding types: ", this.getBindingTypes()));
        buffer.append(Strings.collectionToString("API types: ", this.getTypes()));
        buffer.append(Strings.collectionToString("Injection points: ", this.getInjectionPoints()));
        buffer.append(this.mergedStereotypes.toString() + "\n");
        return buffer.toString();
    }
}

