/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.webbeans.BindingType;
import javax.webbeans.DefinitionException;
import javax.webbeans.Destructor;
import javax.webbeans.Disposes;
import javax.webbeans.Initializer;
import javax.webbeans.Observes;
import javax.webbeans.Produces;
import javax.webbeans.Production;
import javax.webbeans.UnproxyableDependencyException;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.MetaDataCache;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.jlr.AnnotatedClassImpl;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassBean<T>
extends AbstractBean<T, Class<T>> {
    private static final LogProvider log = Logging.getLogProvider(AbstractClassBean.class);
    protected AnnotatedClass<T> annotatedItem;
    private Set<AnnotatedField<Object>> injectableFields;
    private Set<AnnotatedMethod<Object>> initializerMethods;

    public AbstractClassBean(Class<T> type, ManagerImpl manager) {
        super(manager);
        this.annotatedItem = new AnnotatedClassImpl<T>(type);
    }

    @Override
    protected void init() {
        super.init();
        this.checkRequiredTypesImplemented();
        this.checkScopeAllowed();
        this.checkBeanImplementation();
        this.initInitializerMethods();
    }

    @Override
    protected void initType() {
        log.trace("Bean type specified in Java");
        this.type = this.getAnnotatedItem().getType();
    }

    public Set<AnnotatedMethod<Object>> getProducerMethods() {
        return this.getAnnotatedItem().getAnnotatedMethods(Produces.class);
    }

    public Set<AnnotatedField<Object>> getProducerFields() {
        return this.getAnnotatedItem().getAnnotatedFields(Produces.class);
    }

    public Set<AnnotatedMethod<Object>> getObserverMethods() {
        return this.getAnnotatedItem().getMethodsWithAnnotatedParameters(Observes.class);
    }

    @Override
    protected void initInjectionPoints() {
        super.initInjectionPoints();
        this.injectableFields = new HashSet<AnnotatedField<Object>>();
        for (AnnotatedField<Object> annotatedField : this.annotatedItem.getMetaAnnotatedFields(BindingType.class)) {
            if (annotatedField.isAnnotationPresent(Produces.class)) continue;
            if (annotatedField.isStatic()) {
                throw new DefinitionException("Don't place binding annotations on static fields " + annotatedField);
            }
            if (annotatedField.isFinal()) {
                throw new DefinitionException("Don't place binding annotations on final fields " + annotatedField);
            }
            this.injectableFields.add(annotatedField);
            this.injectionPoints.add(annotatedField);
        }
    }

    protected void initInitializerMethods() {
        this.initializerMethods = new HashSet<AnnotatedMethod<Object>>();
        for (AnnotatedMethod<Object> annotatedMethod : this.annotatedItem.getAnnotatedMethods(Initializer.class)) {
            if (annotatedMethod.isStatic()) {
                throw new DefinitionException("Initializer method " + annotatedMethod.toString() + " cannot be static");
            }
            if (annotatedMethod.getAnnotation(Produces.class) != null) {
                throw new DefinitionException("Initializer method " + annotatedMethod.toString() + " cannot be annotated @Produces");
            }
            if (annotatedMethod.getAnnotation(Destructor.class) != null) {
                throw new DefinitionException("Initializer method " + annotatedMethod.toString() + " cannot be annotated @Destructor");
            }
            if (annotatedMethod.getAnnotatedParameters(Disposes.class).size() > 0) {
                throw new DefinitionException("Initializer method " + annotatedMethod.toString() + " cannot have parameters annotated @Disposes");
            }
            if (annotatedMethod.getAnnotatedParameters(Observes.class).size() > 0) {
                throw new DefinitionException("Initializer method " + annotatedMethod.toString() + " cannot be annotated @Observes");
            }
            this.initializerMethods.add(annotatedMethod);
        }
    }

    protected void checkRequiredTypesImplemented() {
        for (Class<?> requiredType : this.getMergedStereotypes().getRequiredTypes()) {
            log.trace("Checking if required type " + requiredType + " is implemented");
            if (requiredType.isAssignableFrom(this.type)) continue;
            throw new DefinitionException("Required type " + requiredType + " isn't implemented on " + this.type);
        }
    }

    protected void checkScopeAllowed() {
        log.trace("Checking if " + this.getScopeType() + " is allowed for " + this.type);
        if (this.getMergedStereotypes().getSupportedScopes().size() > 0 && !this.getMergedStereotypes().getSupportedScopes().contains(this.getScopeType())) {
            throw new DefinitionException("Scope " + this.getScopeType() + " is not an allowed by the stereotype for " + this.type);
        }
    }

    protected void checkBeanImplementation() {
        if (Reflections.isAbstract(this.getType())) {
            throw new DefinitionException("Web Bean implementation class " + this.type + " cannot be declared abstract");
        }
        if (MetaDataCache.instance().getScopeModel(this.getScopeType()).isNormal() && !this.getAnnotatedItem().isProxyable()) {
            throw new UnproxyableDependencyException(this.toString() + " is not proxyable");
        }
    }

    protected AnnotatedClass<T> getAnnotatedItem() {
        return this.annotatedItem;
    }

    @Override
    protected String getDefaultName() {
        String name = Strings.decapitalize(this.getType().getSimpleName());
        log.trace("Default name of " + this.type + " is " + name);
        return name;
    }

    public Set<AnnotatedField<Object>> getInjectableFields() {
        return this.injectableFields;
    }

    public Set<AnnotatedMethod<Object>> getInitializerMethods() {
        return this.initializerMethods;
    }

    @Override
    public String toString() {
        return "AbstractClassBean " + this.getName();
    }

    @Override
    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("AbstractClassBean:\n");
        buffer.append(super.toString() + "\n");
        buffer.append("Annotated item: " + this.annotatedItem.toString() + "\n");
        buffer.append(Strings.collectionToString("Initializer methods: ", this.getInitializerMethods()));
        buffer.append(Strings.collectionToString("Injectable fields: ", this.getInjectableFields()));
        buffer.append(Strings.collectionToString("Producer methods: ", this.getProducerMethods()));
        return buffer.toString();
    }

    @Override
    protected Class<? extends Annotation> getDefaultDeploymentType() {
        return Production.class;
    }
}

