/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.util.HashSet;
import java.util.Set;
import javax.webbeans.ApplicationScoped;
import javax.webbeans.CreationException;
import javax.webbeans.Decorator;
import javax.webbeans.DefinitionException;
import javax.webbeans.Dependent;
import javax.webbeans.Destructor;
import javax.webbeans.Disposes;
import javax.webbeans.Initializer;
import javax.webbeans.Interceptor;
import javax.webbeans.Observes;
import javax.webbeans.Produces;
import javax.webbeans.Specializes;
import javax.webbeans.manager.Manager;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bootstrap.spi.EjbDescriptor;
import org.jboss.webbeans.bootstrap.spi.MethodDescriptor;
import org.jboss.webbeans.contexts.DependentContext;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.JNDI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseBean<T>
extends AbstractClassBean<T> {
    private LogProvider log = Logging.getLogProvider(EnterpriseBean.class);
    private EjbDescriptor<T> ejbDescriptor;
    private AnnotatedMethod<?> removeMethod;

    public EnterpriseBean(Class<T> type, ManagerImpl manager) {
        super(type, manager);
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        Iterable ejbDescriptors = this.manager.getEjbDescriptorCache().get(this.getType());
        if (ejbDescriptors == null) {
            throw new DefinitionException("Not an EJB " + this.toString());
        }
        for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
            if (this.ejbDescriptor == null) {
                this.ejbDescriptor = ejbDescriptor;
                continue;
            }
            throw new RuntimeException("TODO Multiple EJBs have the same bean class! " + this.getType());
        }
        this.initRemoveMethod();
        this.initInjectionPoints();
        this.checkEnterpriseBeanTypeAllowed();
        this.checkEnterpriseScopeAllowed();
        this.checkConflictingRoles();
        this.checkSpecialization();
        this.checkRemoveMethod();
    }

    @Override
    protected void initInjectionPoints() {
        super.initInjectionPoints();
        if (this.removeMethod != null) {
            for (AnnotatedParameter<Object> injectable : this.removeMethod.getParameters()) {
                this.injectionPoints.add(injectable);
            }
        }
    }

    protected void checkConflictingRoles() {
        if (this.getType().isAnnotationPresent(Interceptor.class)) {
            throw new DefinitionException("Enterprise beans cannot be interceptors");
        }
        if (this.getType().isAnnotationPresent(Decorator.class)) {
            throw new DefinitionException("Enterprise beans cannot be decorators");
        }
    }

    protected void checkEnterpriseScopeAllowed() {
        if (this.ejbDescriptor.isStateless() && !this.getScopeType().equals(Dependent.class)) {
            throw new DefinitionException("Scope " + this.getScopeType() + " is not allowed on stateless enterpise beans for " + this.getType() + ". Only @Dependent is allowed on stateless enterprise beans");
        }
        if (this.ejbDescriptor.isSingleton() && !this.getScopeType().equals(Dependent.class) && !this.getScopeType().equals(ApplicationScoped.class)) {
            throw new DefinitionException("Scope " + this.getScopeType() + " is not allowed on singleton enterpise beans for " + this.getType() + ". Only @Dependent or @ApplicationScoped is allowed on singleton enterprise beans");
        }
    }

    private void checkSpecialization() {
        if (!this.getType().isAnnotationPresent(Specializes.class)) {
            return;
        }
        if (!this.manager.getEjbDescriptorCache().containsKey(this.getType().getSuperclass())) {
            throw new DefinitionException("Annotation defined specializing EJB must have EJB superclass");
        }
    }

    protected void initRemoveMethod() {
        if (this.getAnnotatedItem().getAnnotatedMethods(Destructor.class).size() > 1) {
            throw new DefinitionException("Multiple @Destructor methods not allowed on " + this.getAnnotatedItem());
        }
        if (this.getAnnotatedItem().getAnnotatedMethods(Destructor.class).size() == 1) {
            AnnotatedMethod<Object> destructorMethod = this.getAnnotatedItem().getAnnotatedMethods(Destructor.class).iterator().next();
            for (MethodDescriptor removeMethod : this.ejbDescriptor.getRemoveMethods()) {
                AnnotatedMethod<Object> annotatedRemoveMethod = this.getAnnotatedItem().getMethod(removeMethod);
                if (annotatedRemoveMethod == null || !annotatedRemoveMethod.equals(destructorMethod)) continue;
                this.removeMethod = destructorMethod;
                return;
            }
            throw new DefinitionException("Method annotated @Destructor is not an EJB remove method on " + this.toString());
        }
        Set<MethodDescriptor> noArgsRemoveMethods = EnterpriseBean.getNoArgsRemoveMethods(this.ejbDescriptor);
        if (noArgsRemoveMethods.size() == 1) {
            this.removeMethod = this.annotatedItem.getMethod(noArgsRemoveMethods.iterator().next());
            return;
        }
        if (!this.getScopeType().equals(Dependent.class)) {
            throw new DefinitionException("Only @Dependent scoped enterprise beans can be without remove methods " + this.toString());
        }
    }

    private static Set<MethodDescriptor> getNoArgsRemoveMethods(EjbDescriptor<?> ejbDescriptor) {
        HashSet<MethodDescriptor> noArgsRemoveMethods = new HashSet<MethodDescriptor>();
        for (MethodDescriptor removeMethod : ejbDescriptor.getRemoveMethods()) {
            if (removeMethod.getMethodParameterTypes().length != 0) continue;
            noArgsRemoveMethods.add(removeMethod);
        }
        return noArgsRemoveMethods;
    }

    private void checkRemoveMethod() {
        if (this.removeMethod == null) {
            return;
        }
        if (this.ejbDescriptor.isStateless()) {
            throw new DefinitionException("Can't define a remove method on SLSBs");
        }
        if (this.removeMethod.isAnnotationPresent(Initializer.class)) {
            throw new DefinitionException("Remove methods cannot be initializers on " + this.removeMethod.getName());
        }
        if (this.removeMethod.isAnnotationPresent(Produces.class)) {
            throw new DefinitionException("Remove methods cannot be producers on " + this.removeMethod.getName());
        }
        if (this.removeMethod.getAnnotatedParameters(Disposes.class).size() > 0) {
            throw new DefinitionException("Remove method can't have @Disposes annotated parameters on " + this.removeMethod.getName());
        }
        if (this.removeMethod.getAnnotatedParameters(Observes.class).size() > 0) {
            throw new DefinitionException("Remove method can't have @Observes annotated parameters on " + this.removeMethod.getName());
        }
    }

    public T create() {
        try {
            DependentContext.INSTANCE.setActive(true);
            Object object = JNDI.lookup(this.ejbDescriptor.getLocalJndiName());
            return (T)object;
        }
        catch (Exception e) {
            throw new CreationException("could not find the name in JNDI " + this.ejbDescriptor.getLocalJndiName(), (Throwable)e);
        }
        finally {
            DependentContext.INSTANCE.setActive(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(T instance) {
        try {
            DependentContext.INSTANCE.setActive(true);
            this.removeMethod.invokeOnInstance(instance, this.manager);
        }
        catch (Exception e) {
            this.log.error("Error destroying " + this.toString(), e);
        }
        finally {
            DependentContext.INSTANCE.setActive(false);
        }
    }

    protected void callInitializers(T instance) {
        for (AnnotatedMethod<Object> initializer : this.getInitializerMethods()) {
            initializer.invoke((Object)this.manager, instance);
        }
    }

    protected void injectEjbAndCommonFields() {
    }

    protected void injectBoundFields(T instance, Manager manager) {
        for (AnnotatedField<Object> field : this.getInjectableFields()) {
            field.inject(instance, manager);
        }
    }

    @Override
    protected AbstractBean<? extends T, Class<T>> getSpecializedType() {
        Class superclass = this.getAnnotatedItem().getType().getSuperclass();
        if (superclass != null) {
            return new EnterpriseBean(superclass, this.manager);
        }
        throw new RuntimeException();
    }

    public AnnotatedMethod<?> getRemoveMethod() {
        return this.removeMethod;
    }

    private void checkEnterpriseBeanTypeAllowed() {
        if (this.ejbDescriptor.isMessageDriven()) {
            throw new DefinitionException("Message Driven Beans can't be Web Beans");
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.getName() == null) {
            buffer.append(" unnamed enterprise bean");
        } else {
            buffer.append(" enterprise bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getType().getName() + "]\n");
        buffer.append("   API types " + this.getTypes() + ", binding types " + this.getBindingTypes() + "\n");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct(T instance) {
        try {
            DependentContext.INSTANCE.setActive(true);
            this.bindDecorators();
            this.bindInterceptors();
            this.injectEjbAndCommonFields();
            this.injectBoundFields(instance, this.manager);
            this.callInitializers(instance);
        }
        finally {
            DependentContext.INSTANCE.setActive(false);
        }
    }

    public void preDestroy(Object target) {
    }
}

