/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import javax.webbeans.DefinitionException;
import javax.webbeans.Destructor;
import javax.webbeans.Disposes;
import javax.webbeans.Observes;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.AbstractProducerBean;
import org.jboss.webbeans.contexts.DependentContext;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.introspector.AnnotatedType;
import org.jboss.webbeans.introspector.jlr.AnnotatedMethodImpl;
import org.jboss.webbeans.util.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerMethodBean<T>
extends AbstractProducerBean<T, Method> {
    private AnnotatedMethod<T> method;
    private AnnotatedMethod<?> disposalMethod;

    public ProducerMethodBean(Method method, AbstractClassBean<?> declaringBean, ManagerImpl manager) {
        this(new AnnotatedMethodImpl(method, (AnnotatedType<?>)declaringBean.getAnnotatedItem()), declaringBean, manager);
    }

    public ProducerMethodBean(AnnotatedMethod<T> method, AbstractClassBean<?> declaringBean, ManagerImpl manager) {
        super(declaringBean, manager);
        this.method = method;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T create() {
        try {
            DependentContext.INSTANCE.setActive(true);
            T instance = this.method.invoke(this.getReceiver(), this.manager);
            this.checkReturnValue(instance);
            T t = instance;
            return t;
        }
        finally {
            DependentContext.INSTANCE.setActive(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(T instance) {
        try {
            DependentContext.INSTANCE.setActive(true);
        }
        finally {
            DependentContext.INSTANCE.setActive(false);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.checkProducerMethod();
        this.initDisposalMethod();
        this.initInjectionPoints();
    }

    @Override
    protected void initInjectionPoints() {
        super.initInjectionPoints();
        for (AnnotatedParameter<Object> parameter : this.method.getParameters()) {
            this.injectionPoints.add(parameter);
        }
        if (this.disposalMethod != null) {
            for (AnnotatedParameter<Object> injectable : this.disposalMethod.getParameters()) {
                this.injectionPoints.add(injectable);
            }
        }
    }

    protected void checkProducerMethod() {
        if (this.getAnnotatedItem().isAnnotationPresent(Destructor.class)) {
            throw new DefinitionException("Producer method cannot be annotated @Destructor");
        }
        if (this.getAnnotatedItem().getAnnotatedParameters(Observes.class).size() > 0) {
            throw new DefinitionException("Producer method cannot have parameter annotated @Observes");
        }
        if (this.getAnnotatedItem().getAnnotatedParameters(Disposes.class).size() > 0) {
            throw new DefinitionException("Producer method cannot have parameter annotated @Disposes");
        }
    }

    protected void initDisposalMethod() {
        Set<AnnotatedMethod<Object>> disposalMethods = this.manager.resolveDisposalMethods(this.getType(), this.getBindingTypes().toArray(new Annotation[0]));
        if (disposalMethods.size() == 1) {
            this.disposalMethod = disposalMethods.iterator().next();
        } else if (disposalMethods.size() > 1) {
            throw new DefinitionException("Cannot declare multiple disposal methods for this producer method");
        }
    }

    protected AnnotatedMethod<T> getAnnotatedItem() {
        return this.method;
    }

    @Override
    protected String getDefaultName() {
        return this.method.getPropertyName();
    }

    public AnnotatedMethod<?> getDisposalMethod() {
        return this.disposalMethod;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Annotated " + Names.scopeTypeToString(this.getScopeType()));
        if (this.getName() == null) {
            buffer.append("unnamed producer method bean");
        } else {
            buffer.append("simple producer method bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getType().getName() + "]\n");
        buffer.append("   API types " + this.getTypes() + ", binding types " + this.getBindingTypes() + "\n");
        return buffer.toString();
    }

    @Override
    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ProducerMethodBean:\n");
        buffer.append(super.toString() + "\n");
        buffer.append("Declaring bean: " + this.declaringBean.toString() + "\n");
        buffer.append("Method: " + this.method.toString() + "\n");
        return buffer.toString();
    }
}

