/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.webbeans.DefinitionException;
import javax.webbeans.Initializer;
import javax.webbeans.manager.Manager;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.contexts.DependentContext;
import org.jboss.webbeans.introspector.AnnotatedConstructor;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBean<T>
extends AbstractClassBean<T> {
    private static LogProvider log = Logging.getLogProvider(SimpleBean.class);
    private static List<Class<?>> NO_ARGUMENTS = Collections.emptyList();
    private AnnotatedConstructor<T> constructor;
    private AnnotatedMethod<Object> postConstruct;
    private AnnotatedMethod<Object> preDestroy;

    public SimpleBean(Class<T> type, ManagerImpl manager) {
        super(type, manager);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T create() {
        try {
            DependentContext.INSTANCE.setActive(true);
            T instance = this.constructor.newInstance(this.manager);
            this.bindDecorators();
            this.bindInterceptors();
            this.injectEjbAndCommonFields();
            this.injectBoundFields(instance, this.manager);
            this.callInitializers(instance);
            this.callPostConstruct(instance);
            T t = instance;
            return t;
        }
        finally {
            DependentContext.INSTANCE.setActive(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(T instance) {
        try {
            DependentContext.INSTANCE.setActive(true);
            this.callPreDestroy(instance);
        }
        catch (Exception e) {
            log.error("Error destroying " + this.toString(), e);
        }
        finally {
            DependentContext.INSTANCE.setActive(false);
        }
    }

    protected void callPreDestroy(T instance) {
        AnnotatedMethod<Object> preDestroy = this.getPreDestroy();
        if (preDestroy != null) {
            try {
                preDestroy.invoke((Object)instance, this.manager);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke " + preDestroy + " on " + instance, e);
            }
        }
    }

    protected void callPostConstruct(T instance) {
        AnnotatedMethod<Object> postConstruct = this.getPostConstruct();
        if (postConstruct != null) {
            try {
                postConstruct.invoke((Object)instance, this.manager);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke " + postConstruct + " on " + instance, e);
            }
        }
    }

    protected void callInitializers(T instance) {
        for (AnnotatedMethod<Object> initializer : this.getInitializerMethods()) {
            initializer.invoke((Object)instance, this.manager);
        }
    }

    protected void injectEjbAndCommonFields() {
    }

    protected void injectBoundFields(T instance, Manager manager) {
        for (AnnotatedField<Object> injectableField : this.getInjectableFields()) {
            injectableField.inject(instance, manager);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initConstructor();
        SimpleBean.checkType(this.getType());
        this.initInjectionPoints();
        this.initPostConstruct();
        this.initPreDestroy();
    }

    @Override
    protected void initInjectionPoints() {
        super.initInjectionPoints();
        for (AnnotatedParameter<Object> parameter : this.constructor.getParameters()) {
            this.injectionPoints.add(parameter);
        }
    }

    public static void checkType(Class<?> type) {
        if (Reflections.isNonStaticInnerClass(type)) {
            throw new DefinitionException("Simple Web Bean " + type + " cannot be a non-static inner class");
        }
        if (Reflections.isParameterizedType(type)) {
            throw new DefinitionException("Simple Web Bean " + type + " cannot be a parameterized type");
        }
    }

    protected void initConstructor() {
        Set initializerAnnotatedConstructors = this.getAnnotatedItem().getAnnotatedConstructors(Initializer.class);
        log.trace("Found " + initializerAnnotatedConstructors + " constructors annotated with @Initializer for " + this.getType());
        if (initializerAnnotatedConstructors.size() > 1) {
            if (initializerAnnotatedConstructors.size() > 1) {
                throw new DefinitionException("Cannot have more than one constructor annotated with @Initializer for " + this.getType());
            }
        } else if (initializerAnnotatedConstructors.size() == 1) {
            this.constructor = initializerAnnotatedConstructors.iterator().next();
            log.trace("Exactly one constructor (" + this.constructor + ") annotated with @Initializer defined, using it as the bean constructor for " + this.getType());
            return;
        }
        if (this.getAnnotatedItem().getConstructor(NO_ARGUMENTS) != null) {
            this.constructor = this.getAnnotatedItem().getConstructor(NO_ARGUMENTS);
            log.trace("Exactly one constructor (" + this.constructor + ") defined, using it as the bean constructor for " + this.getType());
            return;
        }
        throw new DefinitionException("Cannot determine constructor to use for " + this.getType());
    }

    protected void initPostConstruct() {
        Set<AnnotatedMethod<Object>> postConstructMethods = this.getAnnotatedItem().getAnnotatedMethods(PostConstruct.class);
        log.trace("Found " + postConstructMethods + " constructors annotated with @Initializer for " + this.getType());
        if (postConstructMethods.size() > 1) {
            throw new DefinitionException("Cannot have more than one post construct method annotated with @PostConstruct for " + this.getType());
        }
        if (postConstructMethods.size() == 1) {
            this.postConstruct = postConstructMethods.iterator().next();
            log.trace("Exactly one post construct method (" + this.postConstruct + ") for " + this.getType());
            return;
        }
    }

    protected void initPreDestroy() {
        Set<AnnotatedMethod<Object>> preDestroyMethods = this.getAnnotatedItem().getAnnotatedMethods(PreDestroy.class);
        log.trace("Found " + preDestroyMethods + " constructors annotated with @Initializer for " + this.getType());
        if (preDestroyMethods.size() > 1) {
            throw new DefinitionException("Cannot have more than one pre destroy method annotated with @PreDestroy for " + this.getType());
        }
        if (preDestroyMethods.size() == 1) {
            this.preDestroy = preDestroyMethods.iterator().next();
            log.trace("Exactly one post construct method (" + this.preDestroy + ") for " + this.getType());
            return;
        }
    }

    public AnnotatedConstructor<T> getConstructor() {
        return this.constructor;
    }

    @Override
    protected AbstractBean<? extends T, Class<T>> getSpecializedType() {
        Class superclass = this.getAnnotatedItem().getType().getSuperclass();
        if (superclass != null) {
            return new SimpleBean(superclass, this.manager);
        }
        throw new RuntimeException();
    }

    public AnnotatedMethod<Object> getPostConstruct() {
        return this.postConstruct;
    }

    public AnnotatedMethod<Object> getPreDestroy() {
        return this.preDestroy;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Annotated " + Names.scopeTypeToString(this.getScopeType()));
        if (this.getName() == null) {
            buffer.append("unnamed simple bean");
        } else {
            buffer.append("simple bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getType().getName() + "]\n");
        buffer.append("   API types " + this.getTypes() + ", binding types " + this.getBindingTypes() + "\n");
        return buffer.toString();
    }

    @Override
    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SimpleBean\n");
        buffer.append(super.toString() + "\n");
        buffer.append("Constructor: " + this.constructor.toString() + "\n");
        buffer.append("Post-construct: " + (this.postConstruct == null ? "null" : this.postConstruct.toString()) + "\n");
        buffer.append("Pre-destroy: " + (this.preDestroy == null ? "null" : this.preDestroy.toString()) + "\n");
        return buffer.toString();
    }
}

