/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import javax.webbeans.manager.Bean;
import javax.webbeans.manager.Context;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyMethodHandler
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = -5391564935097267888L;
    private transient Bean<?> bean;
    private int beanIndex;

    public ProxyMethodHandler(Bean<?> bean, int beanIndex) {
        this.bean = bean;
        this.beanIndex = beanIndex;
    }

    public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
        if (this.bean == null) {
            this.bean = CurrentManager.rootManager().getBeans().get(this.beanIndex);
        }
        Context context = CurrentManager.rootManager().getContext(this.bean.getScopeType());
        Object proxiedInstance = context.get(this.bean, true);
        Method proxiedMethod = Reflections.lookupMethod(method, proxiedInstance);
        return proxiedMethod.invoke(proxiedInstance, args);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        String beanInfo = this.bean == null ? "null bean" : this.bean.toString();
        buffer.append("Proxy method handler for " + beanInfo + " with index " + this.beanIndex);
        return buffer.toString();
    }
}

