/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.SystemException;
import javax.webbeans.AfterTransactionCompletion;
import javax.webbeans.AfterTransactionFailure;
import javax.webbeans.AfterTransactionSuccess;
import javax.webbeans.BeforeTransactionCompletion;
import javax.webbeans.DefinitionException;
import javax.webbeans.Destructor;
import javax.webbeans.Disposes;
import javax.webbeans.ExecutionException;
import javax.webbeans.IfExists;
import javax.webbeans.Initializer;
import javax.webbeans.Observer;
import javax.webbeans.ObserverException;
import javax.webbeans.Observes;
import javax.webbeans.Produces;
import javax.webbeans.manager.Bean;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.event.DeferredEventNotification;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.transaction.UserTransaction;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObserverImpl<T>
implements Observer<T> {
    private Bean<?> observerBean;
    private final AnnotatedMethod<Object> observerMethod;
    private TransactionObservationPhase transactionObservationPhase;
    private boolean conditional;
    private ManagerImpl manager;

    public ObserverImpl(AnnotatedMethod<Object> observer, Bean<?> observerBean, ManagerImpl manager) {
        this.manager = manager;
        this.observerBean = observerBean;
        this.observerMethod = observer;
        this.validateObserverMethod();
        this.initTransactionObservationPhase();
        this.conditional = !this.observerMethod.getAnnotatedParameters(IfExists.class).isEmpty();
    }

    private void initTransactionObservationPhase() {
        ArrayList<TransactionObservationPhase> observationPhases = new ArrayList<TransactionObservationPhase>();
        if (!this.observerMethod.getAnnotatedParameters(BeforeTransactionCompletion.class).isEmpty()) {
            observationPhases.add(TransactionObservationPhase.BEFORE_COMPLETION);
        }
        if (!this.observerMethod.getAnnotatedParameters(AfterTransactionCompletion.class).isEmpty()) {
            observationPhases.add(TransactionObservationPhase.AFTER_COMPLETION);
        }
        if (!this.observerMethod.getAnnotatedParameters(AfterTransactionFailure.class).isEmpty()) {
            observationPhases.add(TransactionObservationPhase.AFTER_FAILURE);
        }
        if (!this.observerMethod.getAnnotatedParameters(AfterTransactionSuccess.class).isEmpty()) {
            observationPhases.add(TransactionObservationPhase.AFTER_SUCCESS);
        }
        if (observationPhases.size() > 1) {
            throw new DefinitionException("Transactional observers can only observe on a single phase");
        }
        this.transactionObservationPhase = observationPhases.size() == 1 ? (TransactionObservationPhase)((Object)observationPhases.iterator().next()) : TransactionObservationPhase.NONE;
    }

    private void validateObserverMethod() {
        AnnotatedParameter<Object> eventParam;
        List<AnnotatedParameter<Object>> eventObjects = this.observerMethod.getAnnotatedParameters(Observes.class);
        if (eventObjects.size() > 1) {
            throw new DefinitionException(this + " is invalid because it contains more than event parameter");
        }
        if (eventObjects.size() > 0 && Reflections.isParameterizedType((eventParam = eventObjects.iterator().next()).getType())) {
            throw new DefinitionException(this + " cannot observe parameterized event types");
        }
        List<AnnotatedParameter<Object>> disposeParams = this.observerMethod.getAnnotatedParameters(Disposes.class);
        if (disposeParams.size() > 0) {
            throw new DefinitionException(this + " cannot have any parameters annotated with @Dispose");
        }
        if (this.observerMethod.isAnnotationPresent(Produces.class)) {
            throw new DefinitionException(this + " cannot be annotated with @Produces");
        }
        if (this.observerMethod.isAnnotationPresent(Initializer.class)) {
            throw new DefinitionException(this + " cannot be annotated with @Initializer");
        }
        if (this.observerMethod.isAnnotationPresent(Destructor.class)) {
            throw new DefinitionException(this + " cannot be annotated with @Destructor");
        }
    }

    public void notify(T event) {
        block6: {
            Object instance = this.getInstance(!this.isConditional());
            if (instance != null) {
                try {
                    if (this.isTransactional() && this.isTransactionActive()) {
                        this.deferEvent(event);
                    } else {
                        this.observerMethod.invokeWithSpecialValue(instance, Observes.class, event, this.manager);
                    }
                }
                catch (ExecutionException e) {
                    if (e.getCause() == null || !(e.getCause() instanceof InvocationTargetException)) break block6;
                    InvocationTargetException wrappedException = (InvocationTargetException)e.getCause();
                    if (wrappedException.getCause() != null && RuntimeException.class.isAssignableFrom(wrappedException.getCause().getClass())) {
                        throw (RuntimeException)wrappedException.getCause();
                    }
                    throw new ObserverException(wrappedException.getCause().getMessage(), wrappedException.getCause());
                }
            }
        }
    }

    protected Object getInstance(boolean create) {
        return this.manager.getMostSpecializedInstance(this.observerBean, create);
    }

    private boolean isTransactionActive() {
        UserTransaction userTransaction = this.manager.getInstanceByType(UserTransaction.class, new Annotation[0]);
        try {
            return userTransaction != null && userTransaction.getStatus() == 0;
        }
        catch (SystemException e) {
            return false;
        }
    }

    private void deferEvent(T event) {
        UserTransaction userTransaction = this.manager.getInstanceByType(UserTransaction.class, new Annotation[0]);
        DeferredEventNotification<T> deferredEvent = new DeferredEventNotification<T>(event, this);
        userTransaction.registerSynchronization(deferredEvent);
    }

    public boolean isTransactional() {
        return !TransactionObservationPhase.NONE.equals((Object)this.transactionObservationPhase);
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public boolean isInterestedInTransactionPhase(TransactionObservationPhase currentPhase) {
        return this.transactionObservationPhase.equals((Object)currentPhase);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Observer Implentation: \n");
        builder.append("  Observer (Declaring) bean: " + this.observerBean);
        builder.append("  Observer method: " + this.observerMethod);
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TransactionObservationPhase {
        NONE,
        BEFORE_COMPLETION,
        AFTER_COMPLETION,
        AFTER_FAILURE,
        AFTER_SUCCESS;

    }
}

