/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import com.google.common.collect.ForwardingMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.webbeans.BindingType;
import javax.webbeans.manager.Manager;
import org.jboss.webbeans.bindings.CurrentBinding;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Strings;
import org.jboss.webbeans.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotatedItem<T, S>
implements AnnotatedItem<T, S> {
    private static final Annotation[] DEFAULT_BINDING_ARRAY = new Annotation[]{new CurrentBinding()};
    private static final Set<Annotation> DEFAULT_BINDING = new HashSet<Annotation>(Arrays.asList(DEFAULT_BINDING_ARRAY));
    private String toString;
    private final AnnotationMap annotationMap;
    private final MetaAnnotationMap metaAnnotationMap;
    private final Set<Annotation> annotationSet;

    protected static AnnotationMap buildAnnotationMap(AnnotatedElement element) {
        return AbstractAnnotatedItem.buildAnnotationMap(element.getAnnotations());
    }

    protected static AnnotationMap buildAnnotationMap(Annotation[] annotations) {
        AnnotationMap annotationMap = new AnnotationMap();
        for (Annotation annotation : annotations) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
        return annotationMap;
    }

    protected static Object[] getParameterValues(List<AnnotatedParameter<Object>> parameters, Manager manager) {
        return AbstractAnnotatedItem.getParameterValues(parameters, null, null, manager);
    }

    protected static Object[] getParameterValues(List<AnnotatedParameter<Object>> parameters, Object specialVal, Class<? extends Annotation> specialParam, Manager manager) {
        Object[] parameterValues = new Object[parameters.size()];
        Iterator<AnnotatedParameter<Object>> iterator = parameters.iterator();
        for (int i = 0; i < parameterValues.length; ++i) {
            AnnotatedParameter<Object> param = iterator.next();
            parameterValues[i] = specialParam != null && param.isAnnotationPresent(specialParam) ? specialVal : param.getValue(manager);
        }
        return parameterValues;
    }

    public AbstractAnnotatedItem(AnnotationMap annotationMap) {
        if (annotationMap == null) {
            throw new NullPointerException("annotationMap cannot be null");
        }
        this.annotationMap = annotationMap;
        this.annotationSet = new HashSet<Annotation>();
        this.metaAnnotationMap = new MetaAnnotationMap();
        for (Annotation annotation : annotationMap.values()) {
            for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                if (!MAPPED_METAANNOTATIONS.contains(metaAnnotation.annotationType())) continue;
                this.metaAnnotationMap.put(metaAnnotation.annotationType(), annotation);
            }
            this.annotationSet.add(annotation);
        }
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<? extends A> annotationType) {
        return (A)((Annotation)this.annotationMap.get(annotationType));
    }

    @Override
    public Set<Annotation> getMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet(this.metaAnnotationMap.get(metaAnnotationType));
    }

    @Override
    public Annotation[] getMetaAnnotationsAsArray(Class<? extends Annotation> metaAnnotationType) {
        return this.getMetaAnnotations(metaAnnotationType).toArray(new Annotation[0]);
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotationSet);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotatedType) {
        return this.annotationMap.containsKey(annotatedType);
    }

    protected Map<Class<? extends Annotation>, Annotation> getAnnotationMap() {
        return Collections.unmodifiableMap(this.annotationMap);
    }

    public boolean equals(Object other) {
        if (other instanceof AnnotatedItem) {
            AnnotatedItem that = (AnnotatedItem)other;
            return ((Object)this.getAnnotations()).equals(that.getAnnotations()) && this.getType().equals(that.getType());
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(AnnotatedItem<?, ?> that) {
        return this.isAssignableFrom(that.getType(), that.getActualTypeArguments());
    }

    @Override
    public boolean isAssignableFrom(Set<Class<?>> types) {
        for (Class<?> type : types) {
            if (!this.isAssignableFrom(type, Reflections.getActualTypeArguments(type))) continue;
            return true;
        }
        return false;
    }

    private boolean isAssignableFrom(Class<?> type, Type[] actualTypeArguments) {
        return Types.boxedType(this.getType()).isAssignableFrom(Types.boxedType(type)) && Arrays.equals(this.getActualTypeArguments(), actualTypeArguments);
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Abstract annotated item " + this.getName();
        return this.toString;
    }

    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("AbstractAnnotatedItem:\n");
        buffer.append(Strings.collectionToString("Annotations: ", this.getAnnotations()));
        buffer.append(this.annotationMap == null ? "" : this.annotationMap.toString() + "\n");
        buffer.append(this.metaAnnotationMap == null ? "" : this.metaAnnotationMap.toString() + "\n");
        return buffer.toString();
    }

    @Override
    public Set<Annotation> getBindingTypes() {
        if (this.getMetaAnnotations(BindingType.class).size() > 0) {
            return Collections.unmodifiableSet(this.getMetaAnnotations(BindingType.class));
        }
        return Collections.unmodifiableSet(DEFAULT_BINDING);
    }

    @Override
    public Annotation[] getBindingTypesAsArray() {
        if (this.getMetaAnnotationsAsArray(BindingType.class).length > 0) {
            return this.getMetaAnnotationsAsArray(BindingType.class);
        }
        return DEFAULT_BINDING_ARRAY;
    }

    @Override
    public boolean isProxyable() {
        if (Reflections.getConstructor(this.getType(), new Class[0]) == null) {
            return false;
        }
        if (Reflections.isTypeOrAnyMethodFinal(this.getType())) {
            return false;
        }
        if (Reflections.isPrimitive(this.getType())) {
            return false;
        }
        return !Reflections.isArrayType(this.getType());
    }

    protected abstract S getDelegate();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetaAnnotationMap
    extends ForwardingMap<Class<? extends Annotation>, Set<Annotation>> {
        private final Map<Class<? extends Annotation>, Set<Annotation>> delegate = new HashMap<Class<? extends Annotation>, Set<Annotation>>();

        protected Map<Class<? extends Annotation>, Set<Annotation>> delegate() {
            return this.delegate;
        }

        public Set<Annotation> get(Object key) {
            Set annotations = (Set)super.get(key);
            return annotations != null ? annotations : new HashSet();
        }

        public void put(Class<? extends Annotation> key, Annotation value) {
            HashSet<Annotation> annotations = (HashSet<Annotation>)super.get(key);
            if (annotations == null) {
                annotations = new HashSet<Annotation>();
                super.put(key, annotations);
            }
            annotations.add(value);
        }

        public String toString() {
            return Strings.mapToString("MetaAnnotationMap (annotation type -> annotation set: ", this.delegate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationMap
    extends ForwardingMap<Class<? extends Annotation>, Annotation> {
        private final Map<Class<? extends Annotation>, Annotation> delegate = new HashMap<Class<? extends Annotation>, Annotation>();

        protected Map<Class<? extends Annotation>, Annotation> delegate() {
            return this.delegate;
        }

        public String toString() {
            return Strings.mapToString("AnnotationMap (annotation type -> annotation): ", this.delegate);
        }
    }
}

