/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedItem;
import org.jboss.webbeans.introspector.jlr.AnnotatedClassImpl;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotatedType<T>
extends AbstractAnnotatedItem<T, Class<T>> {
    private final AnnotatedClass<Object> superclass;
    private final String name;
    private String toString;

    public AbstractAnnotatedType(AbstractAnnotatedItem.AnnotationMap annotationMap, Class<T> type) {
        super(annotationMap);
        this.name = type.getName();
        this.superclass = type.getSuperclass() != null ? new AnnotatedClassImpl<Object>(type.getSuperclass()) : null;
    }

    @Override
    public boolean isStatic() {
        return Reflections.isStatic((Class)this.getDelegate());
    }

    @Override
    public boolean isFinal() {
        return Reflections.isFinal((Class)this.getDelegate());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public AnnotatedClass<Object> getSuperclass() {
        return this.superclass;
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Abstract annotated type " + this.getName();
        return this.toString;
    }

    @Override
    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("AbstractAnnotatedType:\n");
        buffer.append(super.toString() + "\n");
        buffer.append("Superclass: " + (this.superclass == null ? "" : this.superclass.toString()) + "\n");
        buffer.append("Name: " + this.getName() + "\n");
        buffer.append("Final: " + this.isFinal() + "\n");
        buffer.append("Static: " + this.isStatic() + "\n");
        return buffer.toString();
    }
}

