/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.webbeans.ExecutionException;
import javax.webbeans.manager.Manager;
import org.jboss.webbeans.introspector.AnnotatedConstructor;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.introspector.AnnotatedType;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedMember;
import org.jboss.webbeans.introspector.jlr.AnnotatedParameterImpl;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedConstructorImpl<T>
extends AbstractAnnotatedMember<T, Constructor<T>>
implements AnnotatedConstructor<T> {
    private static final Type[] actualTypeArguments = new Type[0];
    private final Constructor<T> constructor;
    private final List<AnnotatedParameter<Object>> parameters;
    private final AbstractAnnotatedMember.AnnotatedParameterMap annotatedParameters;
    private final AnnotatedType<T> declaringClass;
    private String toString;

    public AnnotatedConstructorImpl(Constructor<T> constructor, AnnotatedType<T> declaringClass) {
        super(AnnotatedConstructorImpl.buildAnnotationMap(constructor), constructor);
        this.constructor = constructor;
        this.declaringClass = declaringClass;
        this.parameters = new ArrayList<AnnotatedParameter<Object>>();
        this.annotatedParameters = new AbstractAnnotatedMember.AnnotatedParameterMap();
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            AnnotatedParameterImpl<Object> parameter;
            Class<?> clazz;
            if (constructor.getParameterAnnotations()[i].length > 0) {
                clazz = constructor.getParameterTypes()[i];
                parameter = new AnnotatedParameterImpl(constructor.getParameterAnnotations()[i], clazz);
                this.parameters.add(parameter);
                for (Annotation annotation : parameter.getAnnotations()) {
                    this.annotatedParameters.put(annotation.annotationType(), parameter);
                }
                continue;
            }
            clazz = constructor.getParameterTypes()[i];
            parameter = new AnnotatedParameterImpl<Object>(new Annotation[0], clazz);
            this.parameters.add(parameter);
            for (Annotation annotation : parameter.getAnnotations()) {
                this.annotatedParameters.put(annotation.annotationType(), parameter);
            }
        }
    }

    public Constructor<T> getAnnotatedConstructor() {
        return this.constructor;
    }

    @Override
    public Constructor<T> getDelegate() {
        return this.constructor;
    }

    @Override
    public Class<T> getType() {
        return this.constructor.getDeclaringClass();
    }

    @Override
    public Type[] getActualTypeArguments() {
        return actualTypeArguments;
    }

    @Override
    public List<AnnotatedParameter<Object>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public List<AnnotatedParameter<Object>> getAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableList(this.annotatedParameters.get(annotationType));
    }

    @Override
    public T newInstance(Manager manager) {
        try {
            return ((Constructor)this.getDelegate()).newInstance(AnnotatedConstructorImpl.getParameterValues(this.parameters, manager));
        }
        catch (IllegalArgumentException e) {
            throw new ExecutionException("Error instantiating " + this.toString, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ExecutionException("Error instantiating " + this.toString, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException("Error instantiating " + this.toString, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("Error instantiating " + this.toString, (Throwable)e);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other) && other instanceof AnnotatedConstructor) {
            AnnotatedConstructor that = (AnnotatedConstructor)other;
            return this.getDeclaringClass().equals(that.getDeclaringClass()) && ((Object)this.getParameters()).equals(that.getParameters());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Constructor)this.getDelegate()).hashCode();
    }

    @Override
    public AnnotatedType<T> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Annotated method " + Names.constructor2String(this.constructor);
        return this.toString;
    }

    @Override
    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("AnnotatedConstructorImpl:\n");
        buffer.append(super.toString() + "\n");
        buffer.append(Strings.collectionToString("Actual type arguments: ", Arrays.asList(this.getActualTypeArguments())));
        buffer.append("Declaring class:\n");
        buffer.append(this.declaringClass.getName() + "[ " + this.declaringClass.getType() + "]" + "\n");
        buffer.append("Constructor:\n");
        buffer.append(this.constructor.toString() + "\n");
        buffer.append(Strings.collectionToString("Parameters: ", this.getParameters()));
        buffer.append(this.annotatedParameters.toString() + "\n");
        return buffer.toString();
    }
}

