/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.webbeans.manager.Manager;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedType;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedMember;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedFieldImpl<T>
extends AbstractAnnotatedMember<T, Field>
implements AnnotatedField<T> {
    private final Type[] actualTypeArguments;
    private final Field field;
    private final AnnotatedType<?> declaringClass;
    private String toString;

    public AnnotatedFieldImpl(Field field, AnnotatedType<?> declaringClass) {
        super(AnnotatedFieldImpl.buildAnnotationMap(field), field);
        this.field = field;
        this.declaringClass = declaringClass;
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            this.actualTypeArguments = type.getActualTypeArguments();
        } else {
            this.actualTypeArguments = new Type[0];
        }
    }

    @Override
    public Field getAnnotatedField() {
        return this.field;
    }

    @Override
    public Field getDelegate() {
        return this.field;
    }

    @Override
    public Class<T> getType() {
        return this.field.getType();
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public void inject(Object instance, Manager manager) {
        Reflections.setAndWrap(this.getDelegate(), instance, this.getValue(manager));
    }

    @Override
    public void injectIntoInstance(Object instance, Manager manager) {
        Reflections.setAndWrap(this.getName(), instance, this.getValue(manager));
    }

    @Override
    public T get(Object instance) {
        return (T)Reflections.getAndWrap(this.getDelegate(), instance);
    }

    @Override
    public String getPropertyName() {
        return this.getName();
    }

    @Override
    public AnnotatedType<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Annotated method " + Names.field2String(this.field);
        return this.toString;
    }

    @Override
    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("AnnotatedFieldImpl:\n");
        buffer.append(super.toString() + "\n");
        buffer.append(Strings.collectionToString("Actual type arguments: ", Arrays.asList(this.getActualTypeArguments())));
        buffer.append("Declaring class:\n");
        buffer.append(this.declaringClass.getName() + "[ " + this.declaringClass.getType() + "]" + "\n");
        buffer.append("Field: " + this.field + "\n");
        return buffer.toString();
    }
}

