/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.webbeans.BindingType;
import javax.webbeans.manager.Manager;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedItem;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedParameterImpl<T>
extends AbstractAnnotatedItem<T, Object>
implements AnnotatedParameter<T> {
    private final Class<T> type;
    private final Type[] actualTypeArguments = new Type[0];
    private final boolean _final = false;
    private final boolean _static = false;
    private String toString;

    public AnnotatedParameterImpl(Annotation[] annotations, Class<T> type) {
        super(AnnotatedParameterImpl.buildAnnotationMap(annotations));
        this.type = type;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Object getDelegate() {
        return null;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public T getValue(Manager manager) {
        return (T)manager.getInstanceByType(this.getType(), this.getMetaAnnotationsAsArray(BindingType.class));
    }

    @Override
    public String getName() {
        throw new IllegalArgumentException("Unable to determine name of parameter");
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = this.toDetailedString();
        return this.toString;
    }

    @Override
    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("AnnotatedParameterImpl:\n");
        buffer.append("Type: " + this.type.toString() + "\n");
        buffer.append("Annotations: " + Names.annotations2String(this.getAnnotations().toArray(new Annotation[0])));
        buffer.append("Final: false\n");
        buffer.append("Static: false\n");
        buffer.append(Strings.collectionToString("Actual type arguments: ", Arrays.asList(this.getActualTypeArguments())));
        return buffer.toString();
    }
}

