/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.model;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.webbeans.BindingType;
import javax.webbeans.DefinitionException;
import javax.webbeans.NonBinding;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.model.AnnotationModel;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingTypeModel<T extends Annotation>
extends AnnotationModel<T> {
    private Set<AnnotatedMethod<?>> nonBindingTypes;
    private Integer hashCode;

    public BindingTypeModel(Class<T> type) {
        super(type);
    }

    @Override
    protected void init() {
        super.init();
        this.initNonBindingTypes();
        this.checkArrayAndAnnotationValuedMembers();
    }

    private void checkArrayAndAnnotationValuedMembers() {
        for (AnnotatedMethod<?> annotatedMethod : this.getAnnotatedAnnotation().getMembers()) {
            if (!Reflections.isArrayType(annotatedMethod.getType()) && !Annotation.class.isAssignableFrom(annotatedMethod.getType()) || this.nonBindingTypes.contains(annotatedMethod)) continue;
            throw new DefinitionException("Member of array type or annotation type must be annotated @NonBinding " + annotatedMethod);
        }
    }

    @Override
    protected Class<? extends Annotation> getMetaAnnotation() {
        return BindingType.class;
    }

    public boolean hasNonBindingTypes() {
        return this.nonBindingTypes.size() > 0;
    }

    public Set<AnnotatedMethod<?>> getNonBindingTypes() {
        return this.nonBindingTypes;
    }

    protected void initNonBindingTypes() {
        this.nonBindingTypes = this.getAnnotatedAnnotation().getAnnotatedMembers(NonBinding.class);
    }

    public boolean isEqual(Annotation instance, Annotation other) {
        if (instance.annotationType().equals(this.getType()) && other.annotationType().equals(this.getType())) {
            for (AnnotatedMethod<?> annotatedMethod : this.getAnnotatedAnnotation().getMembers()) {
                Object thatValue;
                Object thisValue;
                if (this.nonBindingTypes.contains(annotatedMethod) || (thisValue = annotatedMethod.invoke((Object)instance, new Object[0])).equals(thatValue = annotatedMethod.invoke((Object)other, new Object[0]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return (this.isValid() ? "Valid" : "Invalid") + " binding type model for " + this.getType() + " with non-binding types " + this.getNonBindingTypes();
    }

    @Override
    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("BindingTypeModel:\n");
        buffer.append(super.toString());
        buffer.append("Hash code: " + this.hashCode);
        buffer.append(Strings.collectionToString("Non-binding types: ", this.getNonBindingTypes()));
        return buffer.toString();
    }
}

