/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.servlet;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.bootstrap.WebBeansBootstrap;
import org.jboss.webbeans.bootstrap.spi.WebBeanDiscovery;
import org.jboss.webbeans.contexts.ApplicationContext;
import org.jboss.webbeans.contexts.DependentContext;
import org.jboss.webbeans.contexts.RequestContext;
import org.jboss.webbeans.contexts.SessionContext;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.ApplicationBeanMap;
import org.jboss.webbeans.servlet.SessionBeanMap;
import org.jboss.webbeans.util.Reflections;

public class ServletLifecycle {
    private static LogProvider log = Logging.getLogProvider(ServletLifecycle.class);
    private static ServletContext servletContext;

    public static void beginApplication(ServletContext context) {
        servletContext = context;
        ApplicationContext.INSTANCE.setBeanMap(new ApplicationBeanMap(servletContext));
        WebBeansBootstrap webBeansBootstrap = new WebBeansBootstrap();
        CurrentManager.rootManager().addContext(RequestContext.INSTANCE);
        CurrentManager.rootManager().addContext(SessionContext.INSTANCE);
        CurrentManager.rootManager().addContext(ApplicationContext.INSTANCE);
        webBeansBootstrap.boot(ServletLifecycle.getWebBeanDiscovery());
    }

    public static void endApplication() {
        ApplicationContext.INSTANCE.destroy();
        ApplicationContext.INSTANCE.setBeanMap(null);
        servletContext = null;
    }

    public static void beginSession(HttpSession session) {
    }

    public static void endSession(HttpSession session) {
        SessionContext.INSTANCE.setBeanMap(new SessionBeanMap(session));
        SessionContext.INSTANCE.destroy();
        SessionContext.INSTANCE.setBeanMap(null);
    }

    public static void beginRequest(HttpServletRequest request) {
        SessionContext.INSTANCE.setBeanMap(new SessionBeanMap(request.getSession()));
        DependentContext.INSTANCE.setActive(true);
    }

    public static void endRequest(HttpServletRequest request) {
        DependentContext.INSTANCE.setActive(false);
        RequestContext.INSTANCE.destroy();
        SessionContext.INSTANCE.setBeanMap(null);
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    private static WebBeanDiscovery getWebBeanDiscovery() {
        WebBeanDiscovery webBeanDiscovery = null;
        for (Class<? extends WebBeanDiscovery> clazz : WebBeansBootstrap.getWebBeanDiscoveryClasses()) {
            Constructor<? extends WebBeanDiscovery> constructor = Reflections.getConstructor(clazz, ServletContext.class);
            if (constructor == null) continue;
            try {
                webBeanDiscovery = constructor.newInstance(servletContext);
                break;
            }
            catch (InstantiationException e) {
                log.warn("Error creating WebBeanDiscovery provider" + clazz.getName(), e);
            }
            catch (IllegalAccessException e) {
                log.warn("Error creating WebBeanDiscovery provider" + clazz.getName(), e);
            }
            catch (IllegalArgumentException e) {
                log.warn("Error creating WebBeanDiscovery provider" + clazz.getName(), e);
            }
            catch (InvocationTargetException e) {
                log.warn("Error creating WebBeanDiscovery provider" + clazz.getName(), e);
            }
        }
        return webBeanDiscovery;
    }
}

