/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util;

import com.google.common.collect.ForwardingMap;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentCache<K, V>
extends ForwardingMap<K, Future<V>>
implements Serializable {
    private ConcurrentHashMap<K, Future<V>> map = new ConcurrentHashMap();

    public <T extends V> Future<T> getFuture(K key) {
        return (Future)super.get(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T extends V> T getValue(K key) {
        Future<V> value = this.map.get(key);
        if (value == null) return null;
        boolean interrupted = false;
        while (true) {
            try {
                V v = value.get();
                return (T)v;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                this.rethrow(e);
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public <E> E putIfAbsent(K key, Callable<E> callable) {
        Future<V> value = this.map.get(key);
        if (value == null) {
            FutureTask<E> task = new FutureTask<E>(callable);
            value = task;
            this.map.put(key, task);
            task.run();
        }
        boolean interrupted = false;
        while (true) {
            try {
                V v = value.get();
                return (E)v;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                this.rethrow(e);
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected Map<K, Future<V>> delegate() {
        return this.map;
    }

    protected void rethrow(ExecutionException e) {
        if (e.getCause() instanceof RuntimeException) {
            throw (RuntimeException)e.getCause();
        }
        if (e.getCause() instanceof Error) {
            throw (Error)e.getCause();
        }
        throw new IllegalStateException(e.getCause());
    }
}

