/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.webbeans.ExecutionException;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDI {
    private static final LogProvider log = Logging.getLogProvider(JNDI.class);

    public static InitialContext getInitialContext(Properties props) throws NamingException {
        if (props == null) {
            throw new IllegalStateException("JNDI properties not initialized");
        }
        if (log.isDebugEnabled()) {
            log.debug("JNDI InitialContext properties:" + props);
        }
        try {
            return props.size() == 0 ? new InitialContext() : new InitialContext(props);
        }
        catch (NamingException e) {
            log.debug("Could not obtain initial context", e);
            throw e;
        }
    }

    public static InitialContext getInitialContext() throws NamingException {
        return JNDI.getInitialContext(new Properties());
    }

    public static Object lookup(String name) {
        return JNDI.lookup(name, Object.class);
    }

    public static <T> T lookup(String name, Class<? extends T> expectedType) {
        try {
            return (T)JNDI.getInitialContext().lookup(name);
        }
        catch (NamingException e) {
            throw new ExecutionException("Error looking " + name + " up in JNDI", (Throwable)e);
        }
    }

    public static void bind(String key, Object value) {
        try {
            JNDI.getInitialContext().bind(key, value);
        }
        catch (NamingException e) {
            throw new ExecutionException("Error binding " + value + " to " + key + " in JNDI", (Throwable)e);
        }
    }

    public static void bind(String env, String name, Object value) {
        try {
            Context environment = (Context)JNDI.getInitialContext().lookup(env);
            environment.bind(name, value);
        }
        catch (NamingException e) {
            throw new ExecutionException("Error binding " + value + " to " + name + " in JNDI", (Throwable)e);
        }
    }
}

