/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Names {
    private static Pattern CAPITAL_LETTERS = Pattern.compile("\\p{Upper}{1}\\p{Lower}*");

    public static String scopeTypeToString(Class<? extends Annotation> scopeType) {
        String scopeName = scopeType.getSimpleName();
        Matcher matcher = CAPITAL_LETTERS.matcher(scopeName);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            result.append(matcher.group().toLowerCase() + " ");
        }
        return result.toString();
    }

    public static int count(Iterable<?> iterable) {
        int count = 0;
        Iterator<?> i = iterable.iterator();
        while (i.hasNext()) {
            ++count;
        }
        return count;
    }

    private static String list2String(List<String> list, String delimiter) {
        StringBuilder buffer = new StringBuilder();
        for (String item : list) {
            buffer.append(item);
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    private static List<String> parseModifiers(int modifier) {
        ArrayList<String> modifiers = new ArrayList<String>();
        if (Modifier.isPrivate(modifier)) {
            modifiers.add("private");
        }
        if (Modifier.isProtected(modifier)) {
            modifiers.add("protected");
        }
        if (Modifier.isPublic(modifier)) {
            modifiers.add("public");
        }
        if (Modifier.isAbstract(modifier)) {
            modifiers.add("abstract");
        }
        if (Modifier.isFinal(modifier)) {
            modifiers.add("final");
        }
        if (Modifier.isNative(modifier)) {
            modifiers.add("native");
        }
        if (Modifier.isStatic(modifier)) {
            modifiers.add("static");
        }
        if (Modifier.isStrict(modifier)) {
            modifiers.add("strict");
        }
        if (Modifier.isSynchronized(modifier)) {
            modifiers.add("synchronized");
        }
        if (Modifier.isTransient(modifier)) {
            modifiers.add("transient");
        }
        if (Modifier.isVolatile(modifier)) {
            modifiers.add("volatile");
        }
        if (Modifier.isInterface(modifier)) {
            modifiers.add("interface");
        }
        return modifiers;
    }

    public static String annotations2String(Annotation[] annotations) {
        StringBuilder buffer = new StringBuilder();
        for (Annotation annotation : annotations) {
            buffer.append("@" + annotation.annotationType().getSimpleName());
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public static String field2String(Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return "  Field " + Names.annotations2String(field.getAnnotations()) + Names.list2String(Names.parseModifiers(field.getModifiers()), " ") + field.getName() + ";\n";
    }

    public static String method2String(Method method) {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return "  Method " + method.getReturnType().getSimpleName() + " " + Names.annotations2String(method.getAnnotations()) + Names.list2String(Names.parseModifiers(method.getModifiers()), " ") + method.getName() + "(" + Names.parameters2String(method.getParameterTypes(), method.getParameterAnnotations(), false) + ");\n";
    }

    public static String annotation2String(Annotation annotation) {
        return "Annotation " + Names.annotations2String(annotation.annotationType().getAnnotations()) + annotation.annotationType().getSimpleName();
    }

    public static String constructor2String(Constructor<?> constructor) {
        return "  Constructor " + Names.annotations2String(constructor.getAnnotations()) + Names.list2String(Names.parseModifiers(constructor.getModifiers()), " ") + constructor.getDeclaringClass().getSimpleName() + "(" + Names.parameters2String(constructor.getParameterTypes(), constructor.getParameterAnnotations(), true) + ");\n";
    }

    private static String parameters2String(Class<?>[] parameterTypes, Annotation[][] annotations, boolean constructor) {
        int start;
        StringBuilder buffer = new StringBuilder();
        for (int i = start = constructor ? 1 : 0; i < parameterTypes.length; ++i) {
            if (i > start) {
                buffer.append(", ");
            }
            buffer.append(Names.annotations2String(annotations[i]) + Names.type2String(parameterTypes[i]));
        }
        return buffer.toString();
    }

    public static String type2String(Class<?> clazz) {
        return Names.annotations2String(clazz.getAnnotations()) + clazz.getName();
    }

    public static String class2String(Class<?> clazz) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Class " + Names.type2String(clazz) + "\n");
        for (Field field : clazz.getFields()) {
            buffer.append(Names.field2String(field));
        }
        for (AccessibleObject accessibleObject : clazz.getConstructors()) {
            buffer.append(Names.constructor2String(accessibleObject));
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            buffer.append(Names.method2String((Method)accessibleObject));
        }
        return buffer.toString();
    }
}

